/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProxyMap<K, V>
implements Map<K, V> {
    private final Map[] subs;

    public ProxyMap(Map ... subs) {
        this.subs = subs;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        for (Map m : this.subs) {
            if (m.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map m : this.subs) {
            if (!m.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map m : this.subs) {
            if (!m.containsValue(value)) continue;
            return false;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Map m : this.subs) {
            Object obj = m.get(key);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("This map implementation is not writable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("This map implementation is not writable");
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException("This map implementation is not writable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This map implementation is not writable");
    }

    @Override
    public Set<K> keySet() {
        HashSet keys = new HashSet();
        for (Map m : this.subs) {
            keys.addAll(m.keySet());
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Map m : this.subs) {
            values.addAll(m.values());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map m : this.subs) {
            entries.addAll(m.entrySet());
        }
        return entries;
    }
}

