/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.naming;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

@Immutable
@XmlType(name="RecordType")
public class DefaultRecordType
implements RecordType,
Serializable {
    private static final long serialVersionUID = -116458723163877388L;
    private final RecordSchema parent;
    private final TypeName name;
    private final Map<MemberName, Type> memberTypes;

    private DefaultRecordType() {
        this.parent = null;
        this.name = null;
        this.memberTypes = Collections.emptyMap();
    }

    public DefaultRecordType(RecordType recordType) {
        this.parent = recordType.getContainer();
        this.name = recordType.getTypeName();
        this.memberTypes = recordType.getMemberTypes();
    }

    public DefaultRecordType(RecordSchema recordSchema, TypeName typeName, Map<MemberName, Type> map) {
        this.parent = recordSchema;
        this.name = typeName;
        this.memberTypes = XCollections.unmodifiableMap(new LinkedHashMap<MemberName, Type>(map));
    }

    @Override
    public TypeName getTypeName() {
        return this.name;
    }

    @Override
    public RecordSchema getContainer() {
        return this.parent;
    }

    @Override
    public Map<MemberName, Type> getMemberTypes() {
        return this.memberTypes;
    }

    @Override
    public Set<MemberName> getMembers() {
        return this.memberTypes.keySet();
    }

    @Override
    public TypeName locate(MemberName memberName) {
        Type type = this.memberTypes.get(memberName);
        return type != null ? type.getTypeName() : null;
    }

    @Override
    public boolean isInstance(Record record) {
        return this.memberTypes.keySet().containsAll(record.getAttributes().keySet());
    }

    public int hashCode() {
        int n = ((Object)this.memberTypes).hashCode();
        if (this.name != null) {
            n = 31 * n + this.name.hashCode();
        }
        if (this.parent != null) {
            n = 31 * n + this.parent.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultRecordType defaultRecordType = (DefaultRecordType)object;
            return Utilities.equals((Object)this.name, (Object)defaultRecordType.name) && Utilities.equals((Object)this.parent, (Object)defaultRecordType.parent) && Utilities.equals(this.memberTypes, defaultRecordType.memberTypes);
        }
        return false;
    }

    public String toString() {
        return "RecordType[\"" + this.name + "\"]";
    }
}

