/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.IndexEntry;
import com.occamlab.te.util.DomUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProfileEntry
extends IndexEntry {
    String defaultResult = "Pass";
    QName baseSuite;
    List<List<QName>> excludes = new ArrayList<List<QName>>();
    QName startingTest;
    Document form = null;
    String title = null;
    String description = null;

    public ProfileEntry() {
    }

    public ProfileEntry(Element profile) throws Exception {
        super(profile);
        this.title = DomUtils.getElementByTagName(profile, "title").getTextContent();
        this.description = DomUtils.getElementByTagName(profile, "description").getTextContent();
        Element base = DomUtils.getElementByTagName(profile, "base");
        this.baseSuite = this.getQName(base);
        for (Element exclude : DomUtils.getElementsByTagName(profile, "exclude")) {
            ArrayList<QName> list = new ArrayList<QName>();
            for (Element test : DomUtils.getElementsByTagName(exclude, "test")) {
                list.add(this.getQName(test));
            }
            this.excludes.add(list);
        }
        this.setDefaultResult(DomUtils.getElementByTagName(profile, "defaultResult").getTextContent());
        Element e = DomUtils.getElementByTagName(profile, "starting-test");
        this.startingTest = this.getQName(e);
        Element form_e = DomUtils.getElementByTagNameNS(profile, "http://www.occamlab.com/ctl", "form");
        if (form_e != null) {
            this.form = DomUtils.createDocument(form_e);
        }
    }

    public QName getStartingTest() {
        return this.startingTest;
    }

    public void setStartingTest(QName startingTest) {
        this.startingTest = startingTest;
    }

    public Document getForm() {
        return this.form;
    }

    public void setForm(Document form) {
        this.form = form;
    }

    public QName getBaseSuite() {
        return this.baseSuite;
    }

    public void setBaseSuite(QName baseSuite) {
        this.baseSuite = baseSuite;
    }

    public List<List<QName>> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<List<QName>> excludes) {
        this.excludes = excludes;
    }

    QName getQName(Element e) {
        String prefix = e.getAttribute("prefix");
        String namespaceUri = e.getAttribute("namespace-uri");
        String localName = e.getAttribute("local-name");
        return new QName(namespaceUri, localName, prefix);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultResult() {
        return this.defaultResult;
    }

    public void setDefaultResult(String defaultResult) {
        this.defaultResult = defaultResult;
    }
}

