/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.conformance.RequirementClass;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;

public class CommonDataFixture
extends CommonFixture {
    private static final int DEFAULT_NUMBER_OF_COLLECTIONS = 3;
    private OpenApi3 apiModel = null;
    public URI modelUri = null;
    private List<RequirementClass> requirementClasses;
    protected int noOfCollections = 3;

    public OpenApi3 getModel() {
        if (this.apiModel == null) {
            String msg = "apiModel is null in CommonDataFixture";
            System.out.println(msg);
            throw new NullPointerException(msg);
        }
        return this.apiModel;
    }

    @BeforeClass
    public void requirementClasses(ITestContext testContext) {
        this.requirementClasses = (List)testContext.getSuite().getAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName());
    }

    @BeforeClass
    public void noOfCollections(ITestContext testContext) {
        Object noOfCollections = testContext.getSuite().getAttribute(SuiteAttribute.NO_OF_COLLECTIONS.getName());
        if (noOfCollections != null) {
            this.noOfCollections = (Integer)noOfCollections;
        }
    }

    private URI appendFormatToURI(URI input) {
        URI modelUri = null;
        try {
            modelUri = input.toString().contains("?") ? new URI(input.toString() + "f=application/json") : new URI(input.toString() + "?f=application/json");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modelUri;
    }

    @BeforeClass
    public void retrieveApiModel(ITestContext testContext) {
        this.modelUri = (URI)testContext.getSuite().getAttribute(SuiteAttribute.API_DEFINITION.getName());
        this.apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
    }

    protected List<String> createListOfMediaTypesToSupportForOtherResources(Map<String, Object> linkToSelf) {
        if (this.requirementClasses == null) {
            throw new SkipException("No requirement classes described in  resource /conformance available");
        }
        ArrayList<String> mediaTypesToSupport = new ArrayList<String>();
        for (RequirementClass requirementClass : this.requirementClasses) {
            if (!requirementClass.hasMediaTypeForOtherResources()) continue;
            mediaTypesToSupport.add(requirementClass.getMediaTypeOtherResources());
        }
        if (linkToSelf != null) {
            mediaTypesToSupport.remove(linkToSelf.get("type"));
        }
        return mediaTypesToSupport;
    }

    protected List<String> createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures() {
        if (this.requirementClasses == null) {
            throw new SkipException("No requirement classes described in  resource /conformance available");
        }
        ArrayList<String> mediaTypesToSupport = new ArrayList<String>();
        for (RequirementClass requirementClass : this.requirementClasses) {
            if (!requirementClass.hasMediaTypeForFeaturesAndCollections()) continue;
            mediaTypesToSupport.add(requirementClass.getMediaTypeFeaturesAndCollections());
        }
        return mediaTypesToSupport;
    }

    protected List<String> createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures(Map<String, Object> linkToSelf) {
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures();
        if (linkToSelf != null) {
            mediaTypesToSupport.remove(linkToSelf.get("type"));
        }
        return mediaTypesToSupport;
    }
}

