/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10;

import com.reprezen.kaizen.oasparser.OpenApiParser;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.sun.jersey.api.client.Client;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.TestRunArg;
import org.opengis.cite.ogcapiedr10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapiedr10.util.ClientUtils;
import org.opengis.cite.ogcapiedr10.util.Link;
import org.opengis.cite.ogcapiedr10.util.TestSuiteLogger;
import org.opengis.cite.ogcapiedr10.util.URIUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        if (null != System.getProperty("deleteSubjectOnFinish")) {
            this.deleteTempFiles(suite);
            System.getProperties().remove("deleteSubjectOnFinish");
        }
    }

    void processSuiteParameters(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = params.get(TestRunArg.IUT.toString());
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        suite.setAttribute(SuiteAttribute.IUT.getName(), iutRef);
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", entityFile.getAbsolutePath(), entityFile.length()));
        suite.setAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName(), entityFile);
        String noOfCollections = params.get(TestRunArg.NOOFCOLLECTIONS.toString());
        try {
            if (noOfCollections != null) {
                int noOfCollectionsInt = Integer.parseInt(noOfCollections);
                suite.setAttribute(SuiteAttribute.NO_OF_COLLECTIONS.getName(), noOfCollectionsInt);
            }
        }
        catch (NumberFormatException e) {
            TestSuiteLogger.log(Level.WARNING, String.format("Could not parse parameter %s: %s. Expected is a valid integer", TestRunArg.NOOFCOLLECTIONS.toString(), noOfCollections));
        }
        URI apiDefinitionLocation = URI.create(params.get("apiDefinition"));
        suite.setAttribute(SuiteAttribute.API_DEFINITION.getName(), apiDefinitionLocation);
        File apiDefinitionFile = null;
        try {
            apiDefinitionFile = URIUtils.dereferenceURI(apiDefinitionLocation);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + apiDefinitionLocation, iox);
        }
        String f = "";
        if (!iutRef.toString().contains("f=json") && !iutRef.toString().contains("f=application/json")) {
            f = "f=application/json";
        }
        Response response = null;
        if (ClientUtils.is200Response(URI.create(iutRef.toString() + "?f=application/json"))) {
            response = (Response)RestAssured.given().baseUri(iutRef.toString()).accept(ContentType.JSON).when().request(Method.GET, "?f=application/json", new Object[0]);
            ((ValidatableResponse)response.then()).statusCode(200);
        } else if (ClientUtils.is200Response(URI.create(iutRef.toString() + "?f=json"))) {
            response = (Response)RestAssured.given().baseUri(iutRef.toString()).accept(ContentType.JSON).when().request(Method.GET, "?f=json", new Object[0]);
            ((ValidatableResponse)response.then()).statusCode(200);
        }
        JsonPath jsonPath = response.jsonPath();
        suite.setAttribute(SuiteAttribute.LANDINGPAGEJSONPATH.getName(), jsonPath);
        OpenApiParser parser = new OpenApiParser();
        OpenApi3 apiModel = null;
        try {
            Link apiUrl = OpenApiUtils.parseApiUrl(jsonPath);
            URL resolutionBase = new URL(apiUrl.getHref());
            Response apiModelResponse = (Response)RestAssured.given().accept(apiUrl.getType()).get(apiUrl.getHref(), new Object[0]);
            apiModel = (OpenApi3)parser.parse(apiModelResponse.asString(), resolutionBase);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.SEVERE, "The API definition linked from the Landing Page resulted in an exception.", e);
        }
        suite.setAttribute(SuiteAttribute.API_MODEL.getName(), apiModel);
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), client);
        }
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
        File testSubjFile = (File)suite.getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testSubjFile.exists()) {
            testSubjFile.delete();
        }
    }
}

