/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.encodings.edrgeojson;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.conformance.RequirementClass;
import org.opengis.cite.ogcapiedr10.encodings.geojson.GeoJSONValidator;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class EDRGeoJSONEncoding
extends CommonFixture {
    private String schemaToApply = "/org/opengis/cite/ogcapiedr10/jsonschema/edrgeojson.json";
    protected URI iut;

    @Test(description="Implements Abstract Test 22 (/conf/edr-geojson/definition), Abstract Test 23 (/conf/edr-geojson/content)")
    public void validateResponseForEDRGeoJSON(ITestContext testContext) {
        List requirementClasses = (List)testContext.getSuite().getAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName());
        if (!requirementClasses.contains((Object)RequirementClass.EDRGEOJSON)) {
            throw new SkipException(String.format("Requirements class %s not implemented.", RequirementClass.EDRGEOJSON.getConformanceClass()));
        }
        StringBuffer sb = new StringBuffer();
        boolean atLeastOneCollectionTested = false;
        Response response = this.getCollectionResponse(null);
        JsonPath jsonResponse = response.jsonPath();
        ArrayList collectionsList = (ArrayList)jsonResponse.getList("collections");
        for (int i = 0; i < collectionsList.size() && !atLeastOneCollectionTested; ++i) {
            HashMap dataQueries;
            boolean supportsPositionQuery;
            HashMap collectionItem = (HashMap)collectionsList.get(i);
            String collectionId = collectionItem.get("id").toString();
            if (!collectionItem.containsKey("data_queries") || !(supportsPositionQuery = (dataQueries = (HashMap)collectionItem.get("data_queries")).containsKey("position"))) continue;
            HashMap positionQuery = (HashMap)dataQueries.get("position");
            HashMap link = (HashMap)positionQuery.get("link");
            HashMap variables = (HashMap)link.get("variables");
            ArrayList outputFormatList = (ArrayList)variables.get("output_formats");
            String supportedFormat = null;
            for (int f = 0; f < outputFormatList.size(); ++f) {
                if (!((String)outputFormatList.get(f)).equals("GeoJSON")) continue;
                supportedFormat = (String)outputFormatList.get(f);
            }
            ArrayList crsList = (ArrayList)collectionItem.get("crs");
            String supportedCRS = null;
            for (int f = 0; f < crsList.size(); ++f) {
                if (!((String)crsList.get(f)).equals("CRS84") && !((String)crsList.get(f)).equals("CRS:84") && !((String)crsList.get(f)).equals("WGS84") && !((String)crsList.get(f)).equals("EPSG:4326") && !((String)crsList.get(f)).contains("www.opengis.net/def/crs/OGC/1.3/CRS84")) continue;
                supportedCRS = (String)crsList.get(f);
            }
            double medianx = 0.0;
            double mediany = 0.0;
            HashMap extent = (HashMap)collectionItem.get("extent");
            if (extent.containsKey("spatial")) {
                HashMap spatial = (HashMap)extent.get("spatial");
                if (!spatial.containsKey("bbox")) {
                    sb.append("spatial extent of collection " + collectionId + " missing bbox\n");
                    continue;
                }
                ArrayList bboxEnv = (ArrayList)spatial.get("bbox");
                ArrayList bbox = null;
                if (bboxEnv.get(0).getClass().toString().contains("java.lang.Integer") || bboxEnv.get(0).getClass().toString().contains("java.lang.Double") || bboxEnv.get(0).getClass().toString().contains("java.lang.Float")) {
                    bbox = bboxEnv;
                } else if (bboxEnv.get(0).getClass().toString().contains("java.util.ArrayList")) {
                    bbox = (ArrayList)bboxEnv.get(0);
                }
                if (bbox.size() > 3) {
                    if (bbox.get(0).getClass().toString().contains("Integer") || bbox.get(0).getClass().toString().contains("Double") || bbox.get(0).getClass().toString().contains("Float")) {
                        double minx = Double.parseDouble(bbox.get(0).toString());
                        double miny = Double.parseDouble(bbox.get(1).toString());
                        double maxx = Double.parseDouble(bbox.get(2).toString());
                        double maxy = Double.parseDouble(bbox.get(3).toString());
                        medianx = minx + (maxx - minx) / 2.0;
                        mediany = miny + (maxy - miny) / 2.0;
                    }
                } else {
                    sb.append("bbox of spatial extent of collection" + collectionId + " has fewer than four coordinates\n");
                }
            }
            HashMap parameterNames = (HashMap)collectionItem.get("parameter_names");
            Set parameterNamesSet = parameterNames.keySet();
            Iterator parameterNamesIterator = parameterNamesSet.iterator();
            parameterNamesIterator.hasNext();
            String sampleParamaterName = (String)parameterNamesIterator.next();
            String sampleParamaterNameSafe = null;
            try {
                sampleParamaterNameSafe = URLEncoder.encode(sampleParamaterName, "UTF8");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String sampleDateTime = null;
            if (extent.containsKey("temporal")) {
                HashMap temporal = (HashMap)extent.get("temporal");
                if (!temporal.containsKey("interval")) {
                    sb.append("temporal extent of collection " + collectionId + " missing interval\n");
                    continue;
                }
                ArrayList intervalEnv = (ArrayList)temporal.get("interval");
                ArrayList interval = null;
                interval = intervalEnv.get(0).getClass().toString().contains("java.lang.String") ? intervalEnv : (ArrayList)intervalEnv.get(0);
                if (interval.size() > 1) {
                    sampleDateTime = interval.get(0) + "/" + interval.get(1);
                }
            }
            try {
                if (supportedFormat == null || supportedCRS == null || !supportedFormat.equals("GeoJSON") || !supportedCRS.equals("CRS84") && !supportedCRS.equals("CRS:84") && !supportedCRS.equals("WGS84") && !supportedCRS.equals("EPSG:4326") && !supportedCRS.contains("www.opengis.net/def/crs/OGC/1.3/CRS84")) continue;
                String locationsURL = null;
                locationsURL = supportedCRS.equals("EPSG:4326") ? link.get("href").toString() + "?f=" + supportedFormat + "&crs=EPSG:4326&coords=POINT(" + mediany + "+" + medianx + ")&parameter-name=" + sampleParamaterNameSafe + "&datetime=" + sampleDateTime : link.get("href").toString() + "?f=" + supportedFormat + "&crs=CRS84&coords=POINT(" + medianx + "+" + mediany + ")&parameter-name=" + sampleParamaterNameSafe + "&datetime=" + sampleDateTime;
                GeoJSONValidator validator = new GeoJSONValidator();
                boolean result = validator.isGeoJSONValidPerSchema(locationsURL, -2);
                atLeastOneCollectionTested = true;
                if (result) continue;
                String msg = " GeoJSON returned by Collection " + collectionId + " failed the schema validation test.\n";
                sb.append(msg);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sb.append(" " + ex.getMessage() + "\n");
            }
        }
        EtsAssert.assertTrue(atLeastOneCollectionTested, "Fails Abstract Test 23. None of the collections were found to offer Position resources that return GeoJSON conforming to EDR GeoJSON.\n");
    }
}

