/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.landingpage;

import io.restassured.path.json.JsonPath;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.testng.ITestContext;
import org.testng.annotations.Test;

public class LandingPage
extends CommonFixture {
    private JsonPath jsonPath;

    @Test(description="Implements Abstract Test 2 (/conf/core/root-op) and Abstract Test 3 (/conf/core/root-success) - Landing Page validation", groups={"landingpage"})
    public void edrLandingPageValidation(ITestContext testContext) {
        this.jsonPath = (JsonPath)testContext.getSuite().getAttribute(SuiteAttribute.LANDINGPAGEJSONPATH.getName());
        List<Object> links = this.jsonPath.getList("links");
        Set<String> linkTypes = this.collectLinkTypes(links);
        boolean expectedLinkTypesExists = (linkTypes.contains("service-desc") || linkTypes.contains("service-doc")) && linkTypes.contains("conformance") && linkTypes.contains("data");
        EtsAssert.assertTrue(expectedLinkTypesExists, "The landing page must include at least links with relation types ('service-desc' and/or 'service-doc' ) and 'data' and 'conformance', but contains " + String.join((CharSequence)", ", linkTypes));
    }

    private Set<String> collectLinkTypes(List<Object> links) {
        HashSet<String> linkTypes = new HashSet<String>();
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            linkTypes.add((String)linkType);
        }
        return linkTypes;
    }
}

