/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.collection.EmptyQueue;
import org.geotoolkit.util.collection.EmptySortedSet;

public final class XCollections
extends Static {
    private XCollections() {
    }

    public static void clear(Collection<?> collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    public static void clear(Map<?, ?> map) {
        if (map != null) {
            map.clear();
        }
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <E> boolean addIfNonNull(Collection<E> collection, E e) {
        return collection != null && e != null && collection.add(e);
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.INSTANCE;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EmptySortedSet.INSTANCE;
    }

    public static <E> Set<E> immutableSet(E ... EArray) {
        if (EArray == null) {
            return null;
        }
        switch (EArray.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(EArray[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(EArray)));
    }

    public static <E> Set<E> unmodifiableSet(Set<E> set) {
        if (set != null) {
            switch (set.size()) {
                case 0: {
                    set = Collections.emptySet();
                    break;
                }
                case 1: {
                    set = Collections.singleton(set.iterator().next());
                    break;
                }
                default: {
                    set = Collections.unmodifiableSet(set);
                }
            }
        }
        return set;
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        if (map != null) {
            switch (map.size()) {
                case 0: {
                    map = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    map = Collections.singletonMap(entry.getKey(), entry.getValue());
                    break;
                }
                default: {
                    map = Collections.unmodifiableMap(map);
                }
            }
        }
        return map;
    }

    public static Collection<?> asCollection(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Iterable) {
            ArrayList arrayList = new ArrayList();
            for (Object t : (Iterable)object) {
                arrayList.add(t);
            }
            return arrayList;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
        if (object instanceof Enumeration) {
            return Collections.list((Enumeration)object);
        }
        return Collections.singletonList(object);
    }

    public static <T> List<T> asList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T extends Comparable<T>> Comparator<List<T>> listComparator() {
        return Compare.INSTANCE;
    }

    public static <T extends Comparable<T>> Comparator<SortedSet<T>> sortedSetComparator() {
        return Compare.INSTANCE;
    }

    public static <T extends Comparable<T>> Comparator<Collection<T>> collectionComparator() {
        return Compare.INSTANCE;
    }

    public static int hashMapCapacity(int n) {
        int n2 = n >>> 2;
        if (n != n2 << 2) {
            ++n;
        }
        return n + n2;
    }

    public static <E> Collection<E> copy(Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        Class<?> clazz = collection.getClass();
        if (collection instanceof Set) {
            if (collection instanceof SortedSet) {
                if (clazz == TreeSet.class) {
                    return (Collection)((TreeSet)collection).clone();
                }
                return new TreeSet<E>(collection);
            }
            if (clazz == HashSet.class || clazz == LinkedHashSet.class) {
                return (Collection)((HashSet)collection).clone();
            }
            return new LinkedHashSet<E>(collection);
        }
        if (collection instanceof Queue) {
            if (clazz == LinkedList.class) {
                return (Collection)((LinkedList)collection).clone();
            }
            return new LinkedList<E>(collection);
        }
        if (clazz == ArrayList.class) {
            return (Collection)((ArrayList)collection).clone();
        }
        return new ArrayList<E>(collection);
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        Class<?> clazz = map.getClass();
        if (map instanceof SortedMap) {
            if (clazz == TreeMap.class) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap<K, V>(map);
        }
        if (clazz == HashMap.class || clazz == LinkedHashMap.class) {
            return (Map)((HashMap)map).clone();
        }
        return new LinkedHashMap<K, V>(map);
    }

    private static final class Compare
    implements Comparator<Collection<Comparable>>,
    Serializable {
        static final Comparator<Collection<Comparable>> INSTANCE = new Compare();
        private static final long serialVersionUID = -8926770873102046405L;

        private Compare() {
        }

        @Override
        public int compare(Collection<Comparable> collection, Collection<Comparable> collection2) {
            Comparable comparable;
            Comparable comparable2;
            int n;
            Iterator<Comparable> iterator = collection.iterator();
            Iterator<Comparable> iterator2 = collection2.iterator();
            do {
                boolean bl = iterator.hasNext();
                boolean bl2 = iterator2.hasNext();
                if (!bl) {
                    return bl2 ? -1 : 0;
                }
                if (bl2) continue;
                return 1;
            } while ((n = (comparable2 = iterator.next()).compareTo(comparable = iterator2.next())) == 0);
            return n;
        }
    }
}

