/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10;

import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.filter.log.ResponseLoggingFilter;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class CommonFixture {
    private ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream responseOutputStream = new ByteArrayOutputStream();
    protected RequestLoggingFilter requestLoggingFilter;
    protected ResponseLoggingFilter responseLoggingFilter;
    protected URI rootUri;
    protected URI apiDefUri;
    protected String testingWktPOINT = "POINT(-1.054687%2052.498649)";
    protected String geoJSONTestingCollection = "gfs-surface-precip";
    protected final int DEFAULT_BUFFER_SIZE = 8192;

    @BeforeClass
    public void initCommonFixture(ITestContext testContext) {
        this.initLogging();
        this.rootUri = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        this.apiDefUri = (URI)testContext.getSuite().getAttribute(SuiteAttribute.API_DEFINITION.getName());
    }

    @BeforeMethod
    public void clearMessages() {
        this.initLogging();
    }

    public String getRequest() {
        return this.requestOutputStream.toString();
    }

    public String getResponse() {
        return this.responseOutputStream.toString();
    }

    protected RequestSpecification init() {
        return (RequestSpecification)RestAssured.given().filters((Filter)this.requestLoggingFilter, new Filter[]{this.responseLoggingFilter}).log().all();
    }

    private void initLogging() {
        this.requestOutputStream = new ByteArrayOutputStream();
        this.responseOutputStream = new ByteArrayOutputStream();
        PrintStream requestPrintStream = new PrintStream(this.requestOutputStream, true);
        PrintStream responsePrintStream = new PrintStream(this.responseOutputStream, true);
        this.requestLoggingFilter = new RequestLoggingFilter(requestPrintStream);
        this.responseLoggingFilter = new ResponseLoggingFilter(responsePrintStream);
    }

    protected String constructDateTimeValue(String input) throws Exception {
        String startDateOfInterval = null;
        String endDateOfInterval = null;
        if (!input.contains("00:00Z")) {
            input = input.replace(":00Z", ":00:00Z");
        }
        String[] token = input.split("/");
        for (int i = 0; i < token.length; ++i) {
            if (token[i].split("-").length != 3) continue;
            startDateOfInterval = token[i];
            i = token.length;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar c = Calendar.getInstance();
        c.setTime(sdf.parse(startDateOfInterval));
        c.add(10, 3);
        endDateOfInterval = sdf.format(c.getTime());
        return startDateOfInterval + "/" + endDateOfInterval;
    }

    public String convertInputStreamToString(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    protected Response getCollectionResponse(String collectionId) {
        return JsonUtils.getCollectionResponse(this.rootUri.toString(), collectionId, this.init());
    }
}

