/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.queries;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;

public abstract class AbstractProcessor {
    public final String queryTypeNotSupported = "None of the collections support this query type. Increase the number of collections to parse.";

    public String readStringFromURL(String urlString, int limit) throws Exception {
        String inputLine;
        URL requestURL = new URL(urlString);
        BufferedReader in = new BufferedReader(new InputStreamReader(requestURL.openConnection().getInputStream()));
        StringBuilder response = new StringBuilder();
        for (int i = 0; (inputLine = in.readLine()) != null && i < limit; ++i) {
            response.append(inputLine + "\n");
        }
        in.close();
        return response.toString();
    }

    int getMaximum(int noOfCollections, int collectionsListSize) {
        int maximum = noOfCollections == -1 ? collectionsListSize : noOfCollections;
        maximum = noOfCollections > collectionsListSize ? collectionsListSize : noOfCollections;
        return maximum;
    }

    String getSupportedFormat(List<String> outputFormatList) {
        String supportedFormat = "";
        for (int f = 0; f < outputFormatList.size(); ++f) {
            if (outputFormatList.get(f).equalsIgnoreCase("CoverageJSON") || outputFormatList.get(f).toLowerCase().contains("CoverageJSON".toLowerCase())) {
                supportedFormat = outputFormatList.get(f);
                continue;
            }
            if (!outputFormatList.get(f).equalsIgnoreCase("GeoJSON")) continue;
            supportedFormat = outputFormatList.get(f);
        }
        return supportedFormat;
    }
}

