/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.queries;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.queries.AreaQueryProcessor;
import org.opengis.cite.ogcapiedr10.queries.CorridorQueryProcessor;
import org.opengis.cite.ogcapiedr10.queries.PositionQueryProcessor;
import org.opengis.cite.ogcapiedr10.queries.TrajectoryQueryProcessor;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class QueryCollections
extends CommonFixture {
    private int noOfCollections = 0;
    protected URI iut;

    @BeforeClass
    public void noOfCollections(ITestContext testContext) {
        Object noOfCollections = testContext.getSuite().getAttribute(SuiteAttribute.NO_OF_COLLECTIONS.getName());
        if (noOfCollections != null) {
            this.noOfCollections = (Integer)noOfCollections;
        }
    }

    @DataProvider(name="collectionIDs")
    public Iterator<Object[]> collectionIDs(ITestContext testContext) {
        this.iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        Set<String> collectionTypes = this.extractCollectionIDs(this.iut);
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        collectionsData.add(new Object[]{collectionTypes});
        return collectionsData.iterator();
    }

    private Set<String> extractCollectionIDs(URI rootUri) {
        Response request = (Response)this.init().baseUri(rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/collections", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        JsonPath response = request.jsonPath();
        List collections = response.getList("collections");
        HashSet<String> collectionTypes = new HashSet<String>();
        for (Object collection : collections) {
            Map collectionMap = (Map)collection;
            Object collectionType = collectionMap.get("id");
            collectionTypes.add((String)collectionType);
        }
        return collectionTypes;
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 34 (/conf/position), Abstract Test 50 (/conf/area), Abstract Test 66 (/conf/cube), Abstract Test 82 (/conf/trajectory), Abstract Test 100 (/conf/corridor), Abstract Test 136 (/conf/locations) ")
    public void validateNoQueryParameters(Object collectionIdentifiers) {
        Set collectionIds = (Set)collectionIdentifiers;
        ArrayList collectionsList = new ArrayList();
        collectionsList.addAll(collectionIds);
        boolean foundDataQueries = false;
        int maximum = this.noOfCollections == -1 ? collectionsList.size() : this.noOfCollections;
        maximum = this.noOfCollections > collectionsList.size() ? collectionsList.size() : this.noOfCollections;
        for (int c = 0; c < maximum; ++c) {
            String collectionId = (String)collectionsList.get(c);
            boolean supportsPositionQuery = false;
            boolean supportsAreaQuery = false;
            boolean supportsTrajectoryQuery = false;
            boolean supportsLocationsQuery = false;
            Response response = this.getCollectionResponse(collectionId);
            JsonPath jsonResponse = response.jsonPath();
            HashMap dataQueries = (HashMap)jsonResponse.getJsonObject("data_queries");
            if (dataQueries == null) continue;
            foundDataQueries = true;
            supportsPositionQuery = dataQueries.containsKey("position");
            supportsAreaQuery = dataQueries.containsKey("area");
            supportsTrajectoryQuery = dataQueries.containsKey("trajectory");
            supportsLocationsQuery = dataQueries.containsKey("locations");
            try {
                if (supportsPositionQuery) {
                    response = this.getCollectionResponse(collectionId + "/position");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 34. Expected status code 400 when a Position query with no query parameters are specified for collection " + collectionId);
                }
                if (supportsAreaQuery) {
                    response = this.getCollectionResponse(collectionId + "/area");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 50. Expected status code 400 when a Area query with no query parameters are specified for collection " + collectionId);
                }
                if (supportsTrajectoryQuery) {
                    response = this.getCollectionResponse(collectionId + "/trajectory");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 82. Expected status code 400 when a Trajectory query with no query parameters are specified for collection " + collectionId);
                }
                if (!supportsLocationsQuery) continue;
                response = this.getCollectionResponse(collectionId + "/locations");
                EtsAssert.assertTrue(response.getStatusCode() == 200, "Fails Abstract Test 136. Expected status code 200 when a Locations query with no query parameters are specified for collection " + collectionId);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!foundDataQueries) {
            throw new SkipException("No data_queries element was present in tested collections.");
        }
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 35 (/conf/position),Abstract Test 36 (/conf/position), Abstract Test 51 (/conf/area), Abstract Test 52 (/conf/area), Abstract Test 83 (/conf/trajectory), Abstract Test 101 (/conf/corridor)")
    public void validateCoordsQueryParameters(Object collectionIdentifiers) {
        Set collectionIds = (Set)collectionIdentifiers;
        ArrayList collectionsList = new ArrayList();
        collectionsList.addAll(collectionIds);
        boolean foundDataQueries = false;
        int maximum = this.noOfCollections == -1 ? collectionsList.size() : this.noOfCollections;
        maximum = this.noOfCollections > collectionsList.size() ? collectionsList.size() : this.noOfCollections;
        for (int c = 0; c < maximum; ++c) {
            String collectionId = (String)collectionsList.get(c);
            boolean supportsPositionQuery = false;
            boolean supportsAreaQuery = false;
            boolean supportsTrajectoryQuery = false;
            boolean supportsCorridorQuery = false;
            Response response = this.getCollectionResponse(collectionId);
            JsonPath jsonResponse = response.jsonPath();
            HashMap dataQueries = (HashMap)jsonResponse.getJsonObject("data_queries");
            if (dataQueries == null) continue;
            foundDataQueries = true;
            supportsPositionQuery = dataQueries.containsKey("position");
            supportsAreaQuery = dataQueries.containsKey("area");
            supportsTrajectoryQuery = dataQueries.containsKey("trajectory");
            supportsCorridorQuery = dataQueries.containsKey("corridor");
            try {
                if (supportsPositionQuery) {
                    response = this.getCollectionResponse(collectionId + "/position?coords=");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 35. Expected status code 400 when a Position query with coords query parameter is not specified for collection " + collectionId);
                    response = this.getCollectionResponse(collectionId + "/position?coords=POINT()");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 36. Expected status code 400 when a Position coords query parameter does not contain a valid POINT Well Known Text value for collection " + collectionId);
                }
                if (supportsAreaQuery) {
                    response = this.getCollectionResponse(collectionId + "/area?coords=");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 51. Expected status code 400 when an Area query with coords query parameter is not specified for collection " + collectionId);
                    response = this.getCollectionResponse(collectionId + "/area?coords=POLYGON()");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 52. Expected status code 400 when an Area query with coords query parameter does not contain a valid POLYGON Well Known Text value for collection " + collectionId);
                }
                if (supportsTrajectoryQuery) {
                    response = this.getCollectionResponse(collectionId + "/trajectory?coords=");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 83. Expected status code 400 when a Trajectory query with coords query parameter is not specified for collection " + collectionId);
                    response = this.getCollectionResponse(collectionId + "/trajectory?coords=LINESTRING()");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 84. Expected status code 400 when a Trajectory query with coords query parameter does not contain a valid LINESTRING Well Known Text value for collection " + collectionId);
                    response = this.getCollectionResponse(collectionId + "/trajectory?coords=LINESTRINGM()");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 85. Expected status code 400 when a Trajectory query with coords query parameter does not contain a valid LINESTRING Well Known Text value for collection " + collectionId);
                    response = this.getCollectionResponse(collectionId + "/trajectory?coords=LINESTRINGZM()");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 88. Expected status code 400 when a Trajectory query with coords query parameter does not contain a valid LINESTRING Well Known Text value for collection " + collectionId);
                    response = this.getCollectionResponse(collectionId + "/trajectory?coords=LINESTRINGZ()");
                    EtsAssert.assertTrue(response.getStatusCode() == 400, "Fails Abstract Test 89. Expected status code 400 when a Trajectory query with coords query parameter does not contain a valid LINESTRING Well Known Text value for collection " + collectionId);
                }
                if (!supportsCorridorQuery) continue;
                response = this.getCollectionResponse(collectionId + "/corridor?coords=");
                EtsAssert.assertTrue(response.getStatusCode() == 400, "Expected status code 400 when a Corridor query with coords query parameter is not specified for collection " + collectionId);
                response = this.getCollectionResponse(collectionId + "/corridor?coords=LINESTRING()");
                EtsAssert.assertTrue(response.getStatusCode() == 400, "Expected status code 400 when a Corridor query with coords query parameter does not contain a valid LINESTRING Well Known Text value for collection " + collectionId);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!foundDataQueries) {
            throw new SkipException("No data_queries element was present in tested collections.");
        }
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 37 (/conf/position), Abstract Test 39 (/conf/edr/rc-coords-response), Abstract Test 41 (/conf/edr/rc-z-response),  Abstract Test 43 (/conf/core/datetime-response),  Abstract Test 45 (/conf/edr/rc-parameter-name-response), Abstract Test 47 (/conf/edr/REQ_rc-crs-response), Abstract Test 49 (/conf/collections/rc-f-response)")
    public void validatePositionQueryUsingParameters(Object collectionIdentifiers) {
        Set collectionIds = (Set)collectionIdentifiers;
        PositionQueryProcessor processor = new PositionQueryProcessor();
        String resultMessage = processor.validatePositionQueryUsingParameters(collectionIds, this.rootUri.toString(), this.noOfCollections, this.init());
        Objects.requireNonNull(processor);
        if (resultMessage.contains("None of the collections support this query type. Increase the number of collections to parse.")) {
            Objects.requireNonNull(processor);
            throw new SkipException("None of the collections support this query type. Increase the number of collections to parse.");
        }
        EtsAssert.assertTrue(resultMessage.length() == 0, "Fails Abstract Test 37. Therefore could not verify the implementation passes Abstract Tests 39, 41, 43, 45, 47, and 49. Expected information that matches the selection criteria is returned for Position query. " + resultMessage);
    }

    private String printKeys(HashMap input) {
        StringBuffer sb = new StringBuffer();
        Iterator inputIterator = input.keySet().iterator();
        while (inputIterator.hasNext()) {
            sb.append((String)inputIterator.next() + " \n");
        }
        return sb.toString();
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 53 (/conf/area), Abstract Test 55 (/conf/edr/rc-coords-response), Abstract Test 57 (/conf/edr/rc-z-response),  Abstract Test 59 (/conf/core/datetime-response),  Abstract Test 61 (/conf/edr/rc-parameter-name-response), Abstract Test 63 (/conf/edr/REQ_rc-crs-response), Abstract Test 65 (/conf/collections/rc-f-response)")
    public void validateAreaQueryUsingParameters(Object collectionIdentifiers) {
        Set collectionIds = (Set)collectionIdentifiers;
        AreaQueryProcessor processor = new AreaQueryProcessor();
        String resultMessage = processor.validateAreaQueryUsingParameters(collectionIds, this.rootUri.toString(), this.noOfCollections, this.init());
        Objects.requireNonNull(processor);
        if (resultMessage.contains("None of the collections support this query type. Increase the number of collections to parse.")) {
            Objects.requireNonNull(processor);
            throw new SkipException("None of the collections support this query type. Increase the number of collections to parse.");
        }
        EtsAssert.assertTrue(resultMessage.length() == 0, "Fails Abstract Test 53. Therefore could not verify the implementation passes Abstract Tests 55, 57, 59, 61, 63, 65. Expected information that matches the selection criteria is returned for Area query. " + resultMessage);
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 91 (/conf/trajectory), Abstract Test 93 (/conf/edr/rc-coords-response),  Abstract Test 95 (/conf/edr/rc-parameter-name-response), Abstract Test 97 (/conf/edr/REQ_rc-crs-response), Abstract Test 99 (/conf/collections/rc-f-response)")
    public void validateTrajectoryQueryUsingParameters(Object collectionIdentifiers) {
        Set collectionIds = (Set)collectionIdentifiers;
        TrajectoryQueryProcessor processor = new TrajectoryQueryProcessor();
        String resultMessage = processor.validateTrajectoryQueryUsingParameters(collectionIds, this.rootUri.toString(), this.noOfCollections, this.init());
        Objects.requireNonNull(processor);
        if (resultMessage.contains("None of the collections support this query type. Increase the number of collections to parse.")) {
            Objects.requireNonNull(processor);
            throw new SkipException("None of the collections support this query type. Increase the number of collections to parse.");
        }
        EtsAssert.assertTrue(resultMessage.length() == 0, "Fails Abstract Test 91. Therefore could not verify the implementation passes Abstract Tests 91, 93, 95, 97, 99. Expected information that matches the selection criteria is returned for Trajectory query. " + resultMessage);
    }

    @Test(dataProvider="collectionIDs", description="Implements Abstract Test 115 (/conf/corridor), Abstract Test 117 (/conf/edr/rc-coords-response), Abstract Test 119 (/conf/collections/REQ_rc-corridor-width-response), Abstract Test 121 (/conf/collections/REQ_rc-corridor-height-response), Abstract Test 123 (/conf/collections/REQ_rc-width-units-response), Abstract Test 125 (/conf/collections/rc-height-units-response),  Abstract Test 127 (/conf/edr/rc-parameter-name-response), Abstract Test 129 (/conf/edr/REQ_rc-crs-response), Abstract Test 131 (/conf/collections/rc-f-response)")
    public void validateCorridorQueryUsingParameters(Object collectionIdentifiers) {
        CorridorQueryProcessor processor = new CorridorQueryProcessor();
        Set collectionIds = (Set)collectionIdentifiers;
        String resultMessage = processor.validateCorridorQueryUsingParameters(collectionIds, this.rootUri.toString(), this.noOfCollections, this.init());
        if (resultMessage.contains(processor.queryTypeNotSupported)) {
            throw new SkipException(processor.queryTypeNotSupported);
        }
        EtsAssert.assertTrue(resultMessage.length() == 0, "Fails Abstract Test 115. Therefore could not verify the implementation passes Abstract Tests 115, 117, 119, 121, 123, 125, 129, 131. Expected information that matches the selection criteria is returned for Corridor query. " + resultMessage);
    }

    private String readStringFromURL(String urlString, int limit) throws Exception {
        String inputLine;
        URL requestURL = new URL(urlString);
        BufferedReader in = new BufferedReader(new InputStreamReader(requestURL.openConnection().getInputStream()));
        StringBuilder response = new StringBuilder();
        for (int i = 0; (inputLine = in.readLine()) != null && i < limit; ++i) {
            response.append(inputLine + "\n");
        }
        in.close();
        return response.toString();
    }
}

