/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.Code;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.Reference;
import org.geotoolkit.gml.xml.WithCoordinates;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public interface Envelope
extends org.opengis.geometry.Envelope,
AbstractGeometry,
WithCoordinates {
    @Override
    public void setSrsDimension(Integer var1);

    public List<String> getAxisLabels();

    public void setAxisLabels(List<String> var1);

    public List<String> getUomLabels();

    public List<? extends DirectPosition> getPos();

    public boolean isCompleteEnvelope2D();

    @Override
    default public CoordinateReferenceSystem getCoordinateReferenceSystem(boolean longitudeFirst) {
        if (this.getSrsName() != null) {
            try {
                CoordinateReferenceSystem crs = CRS.forCode((String)this.getSrsName());
                if (longitudeFirst) {
                    crs = AbstractCRS.castOrCopy((CoordinateReferenceSystem)crs).forConvention(AxesConvention.RIGHT_HANDED);
                }
                return crs;
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.gml.xml.v321").log(Level.WARNING, "Could not decode CRS which name is : " + this.getSrsName(), ex);
            }
        }
        return null;
    }

    @Override
    default public int getCoordinateDimension() {
        Integer bi = this.getSrsDimension();
        if (bi == null) {
            return 2;
        }
        return bi;
    }

    @Override
    default public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void setSrsName(String srsName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Code getParameterName() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public String getDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    default public void setDescription(String description) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    default public void setName(Identifier name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    default public Reference getDescriptionReference() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    default public Identifier getName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    default public String getId() {
        return null;
    }
}

