/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.jaxb.ModifiableIdentifierMap;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.geotoolkit.gml.GMLStandard;
import org.geotoolkit.gml.xml.AbstractGML;
import org.geotoolkit.gml.xml.v311.AbstractFeatureType;
import org.geotoolkit.gml.xml.v311.AbstractGeometryType;
import org.geotoolkit.gml.xml.v311.AbstractTimeObjectType;
import org.geotoolkit.gml.xml.v311.ArrayType;
import org.geotoolkit.gml.xml.v311.BagType;
import org.geotoolkit.gml.xml.v311.CodeType;
import org.geotoolkit.gml.xml.v311.DefinitionType;
import org.geotoolkit.gml.xml.v311.ReferenceType;
import org.geotoolkit.internal.sql.Entry;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractGMLType", propOrder={"description", "descriptionReference", "name", "parameterName"})
@XmlSeeAlso(value={ArrayType.class, AbstractTimeObjectType.class, DefinitionType.class, BagType.class, AbstractGeometryType.class, AbstractFeatureType.class})
public abstract class AbstractGMLType
extends AbstractMetadata
implements AbstractGML,
Serializable,
Entry,
IdentifiedObject {
    public static final GMLStandard STANDARD = new GMLStandard("GML 3.1.1", AbstractGML.class.getPackage(), "v311", MetadataStandard.ISO_19111);
    private String description;
    private ReferenceType descriptionReference;
    @XmlTransient
    protected String name;
    @XmlAttribute(namespace="http://www.opengis.net/gml", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    private String id;
    private CodeType parameterName;
    @XmlTransient
    protected Set<Identifier> identifiers;

    protected AbstractGMLType() {
    }

    public AbstractGMLType(AbstractGML a) {
        if (a != null) {
            this.description = a.getDescription();
            if (a.getDescriptionReference() != null) {
                this.descriptionReference = new ReferenceType(a.getDescriptionReference());
            }
            this.setId(a.getId());
            if (a.getName() != null) {
                this.name = a.getName().getCode();
            }
            if (a.getParameterName() != null) {
                this.parameterName = new CodeType(a.getParameterName().getValue(), a.getParameterName().getCodeSpace());
            }
        }
    }

    public AbstractGMLType(String id) {
        this.setId(id);
    }

    public AbstractGMLType(String id, String name, String description, ReferenceType descriptionReference) {
        this.setId(id);
        this.name = name;
        this.description = description;
        this.descriptionReference = descriptionReference;
    }

    public MetadataStandard getStandard() {
        return STANDARD;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public ReferenceType getDescriptionReference() {
        return this.descriptionReference;
    }

    public void setDescription(ReferenceType value) {
        this.descriptionReference = value;
    }

    @Override
    @XmlElement
    public Identifier getName() {
        if (this.name != null) {
            return new DefaultIdentifier(this.name);
        }
        return null;
    }

    @Override
    public void setName(Identifier name) {
        this.name = name != null ? name.getCode() : null;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = (String)this.getIdentifierMap().get((Object)IdentifierSpace.ID);
        }
        return this.id;
    }

    public String getIdentifier() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (value != null) {
            this.getIdentifierMap().put((Object)IdentifierSpace.ID, (Object)value);
        } else {
            this.getIdentifierMap().remove((Object)IdentifierSpace.ID);
        }
        this.id = value;
    }

    @Override
    public CodeType getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(CodeType parameterName) {
        this.parameterName = parameterName;
    }

    public Set<Identifier> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<Identifier>();
        }
        return this.identifiers;
    }

    public IdentifierMap getIdentifierMap() {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<Identifier>();
        }
        return new ModifiableIdentifierMap(this.identifiers);
    }

    public Collection<GenericName> getAlias() {
        return null;
    }

    public InternationalString getRemarks() {
        if (this.description != null) {
            return new SimpleInternationalString(this.description);
        }
        return null;
    }

    public String toWKT() throws UnsupportedOperationException {
        return null;
    }

    public void prune() {
    }

    public boolean equals(Object obj, ComparisonMode mode) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractGMLType) {
            AbstractGMLType that = (AbstractGMLType)obj;
            return Objects.equals(this.description, that.description) && Objects.equals(this.descriptionReference, that.descriptionReference) && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.parameterName, that.parameterName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 67 * hash + (this.descriptionReference != null ? this.descriptionReference.hashCode() : 0);
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 67 * hash + (this.parameterName != null ? this.parameterName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.getClass().getSimpleName()).append(']').append('\n');
        if (this.id != null) {
            sb.append("id:").append(this.getId()).append('\n');
        }
        if (this.name != null) {
            sb.append("name:").append(this.name).append('\n');
        }
        if (this.description != null) {
            sb.append("description:").append(this.description).append('\n');
        }
        if (this.descriptionReference != null) {
            sb.append("description reference:").append(this.descriptionReference).append('\n');
        }
        return sb.toString();
    }
}

