/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.citation;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.opengis.annotation.Classifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.Stereotype;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@Classifier(value=Stereotype.DATATYPE)
@UML(identifier="CI_Citation", specification=Specification.ISO_19115)
public interface Citation {
    @UML(identifier="title", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public InternationalString getTitle();

    @UML(identifier="alternateTitle", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends InternationalString> getAlternateTitles() {
        return Collections.emptyList();
    }

    @UML(identifier="date", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends CitationDate> getDates() {
        return Collections.emptyList();
    }

    @UML(identifier="edition", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public InternationalString getEdition() {
        return null;
    }

    @UML(identifier="editionDate", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Date getEditionDate() {
        return null;
    }

    @UML(identifier="identifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Identifier> getIdentifiers() {
        return Collections.emptyList();
    }

    @UML(identifier="citedResponsibleParty", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends Responsibility> getCitedResponsibleParties() {
        return Collections.emptyList();
    }

    @UML(identifier="presentationForm", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<PresentationForm> getPresentationForms() {
        return Collections.emptySet();
    }

    @UML(identifier="series", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Series getSeries() {
        return null;
    }

    @UML(identifier="otherCitationDetails", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends InternationalString> getOtherCitationDetails() {
        return Collections.emptyList();
    }

    @Deprecated
    @UML(identifier="collectiveTitle", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115, version=2003)
    default public InternationalString getCollectiveTitle() {
        return null;
    }

    @UML(identifier="ISBN", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public String getISBN() {
        return null;
    }

    @UML(identifier="ISSN", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public String getISSN() {
        return null;
    }

    @UML(identifier="onlineResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends OnlineResource> getOnlineResources() {
        return Collections.emptyList();
    }

    @UML(identifier="graphic", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    default public Collection<? extends BrowseGraphic> getGraphics() {
        return Collections.emptyList();
    }
}

