/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.quality;

import java.util.Collection;
import java.util.Collections;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.quality.BasicMeasure;
import org.opengis.metadata.quality.Description;
import org.opengis.metadata.quality.SourceReference;
import org.opengis.metadata.quality.ValueStructure;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.InternationalString;
import org.opengis.util.TypeName;

@UML(identifier="DQM_Measure", specification=Specification.ISO_19157)
public interface Measure {
    @UML(identifier="measureIdentifier", obligation=Obligation.MANDATORY, specification=Specification.ISO_19157)
    public Identifier getMeasureIdentifier();

    @UML(identifier="name", obligation=Obligation.MANDATORY, specification=Specification.ISO_19157)
    public InternationalString getName();

    @UML(identifier="alias", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public Collection<? extends InternationalString> getAliases() {
        return Collections.emptyList();
    }

    @UML(identifier="elementName", obligation=Obligation.MANDATORY, specification=Specification.ISO_19157)
    public Collection<? extends TypeName> getElementNames();

    @UML(identifier="basicMeasure", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    default public BasicMeasure getBasicMeasure() {
        return null;
    }

    @UML(identifier="definition", obligation=Obligation.MANDATORY, specification=Specification.ISO_19157)
    public InternationalString getDefinition();

    @UML(identifier="description", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    public Description getDescription();

    @UML(identifier="sourceReference", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    default public Collection<? extends SourceReference> getSourceReferences() {
        return Collections.emptyList();
    }

    @UML(identifier="valueType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19157)
    public TypeName getValueType();

    @UML(identifier="valueStructure", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public ValueStructure getValueStructure() {
        return null;
    }

    @UML(identifier="parameter", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19157)
    default public Collection<? extends ParameterDescriptor<?>> getParameters() {
        return Collections.emptyList();
    }

    @UML(identifier="example", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19157)
    default public Collection<? extends Description> getExamples() {
        return Collections.emptyList();
    }
}

