/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.Static;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public final class NameMeaning
extends Static {
    private static final Class<?>[] CLASSES = new Class[]{CoordinateReferenceSystem.class, Datum.class, Ellipsoid.class, PrimeMeridian.class, CoordinateSystem.class, CoordinateSystemAxis.class, CoordinateOperation.class, OperationMethod.class, ParameterDescriptor.class, ReferenceSystem.class, Unit.class};
    private static final String[] TYPES = new String[]{"crs", "datum", "ellipsoid", "meridian", "cs", "axis", "coordinateOperation", "method", "parameter", "referenceSystem", "uom"};
    private static final Map<String, String> AUTHORITIES = Map.ofEntries(NameMeaning.entry("EPSG"), NameMeaning.entry("OGC"), NameMeaning.entry("OGC-WFS"), NameMeaning.entry("SI"), NameMeaning.entry("UCUM"), NameMeaning.entry("UNSD"), NameMeaning.entry("USNO"));

    private static Map.Entry<String, String> entry(String authority) {
        return Map.entry(authority, authority);
    }

    private NameMeaning() {
    }

    public static String toURN(Class<?> type, String authority, String version, String code) {
        if (type == null || authority == null || code == null) {
            return null;
        }
        String key = authority.toUpperCase(Locale.US);
        String codeSpace = AUTHORITIES.get(key);
        if (codeSpace == null) {
            Citation c = Citations.fromName(key);
            codeSpace = Citations.toCodeSpace(c);
            if (AUTHORITIES.get(codeSpace) == null) {
                return null;
            }
            version = NameMeaning.getVersion(c);
            if (!authority.equals(codeSpace) && !((String)code).startsWith(authority)) {
                code = authority + (String)code;
            }
        }
        StringBuilder buffer = new StringBuilder("urn:ogc:def");
        int p = 0;
        block6: while (true) {
            String part;
            switch (p) {
                case 0: {
                    part = NameMeaning.toObjectType(type);
                    break;
                }
                case 1: {
                    part = codeSpace;
                    break;
                }
                case 2: {
                    part = version;
                    break;
                }
                case 3: {
                    part = code;
                    break;
                }
                default: {
                    break block6;
                }
            }
            if (!Strings.appendUnicodeIdentifier(buffer.append(':'), '\u0000', part, ".-", false) && p != 2) {
                return null;
            }
            ++p;
        }
        return buffer.toString();
    }

    public static String toObjectType(Class<?> type) {
        for (int i = 0; i < CLASSES.length; ++i) {
            if (!CLASSES[i].isAssignableFrom(type)) continue;
            return TYPES[i];
        }
        return null;
    }

    public static String getVersion(Citation authority) {
        InternationalString i18n;
        if (authority != null && (i18n = authority.getEdition()) != null) {
            return i18n.toString(Locale.US);
        }
        return null;
    }
}

