/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import javax.measure.Unit;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.jaxb.metadata.CI_Citation;
import org.apache.sis.internal.jaxb.metadata.MD_Identifier;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.metadata.legacy.MediumName;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Medium_Type", propOrder={"identifier", "name", "legacyName", "density", "densities", "densityUnits", "volumes", "mediumFormats", "mediumNote"})
@XmlRootElement(name="MD_Medium")
public class DefaultMedium
extends ISOMetadata
implements Medium {
    private static final long serialVersionUID = -460355952171320089L;
    private Citation name;
    private Double density;
    private Unit<?> densityUnits;
    private Integer volumes;
    private Collection<MediumFormat> mediumFormats;
    private InternationalString mediumNote;

    public DefaultMedium() {
    }

    public DefaultMedium(Medium object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.density = object.getDensity();
            this.densityUnits = object.getDensityUnits();
            this.volumes = object.getVolumes();
            this.mediumFormats = this.copyCollection(object.getMediumFormats(), MediumFormat.class);
            this.mediumNote = object.getMediumNote();
            this.identifiers = this.singleton(object.getIdentifier(), Identifier.class);
        }
    }

    public static DefaultMedium castOrCopy(Medium object) {
        if (object == null || object instanceof DefaultMedium) {
            return (DefaultMedium)object;
        }
        return new DefaultMedium(object);
    }

    @XmlElement(name="name")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="density")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    public Double getDensity() {
        return this.density;
    }

    public void setDensity(Double newValue) {
        this.checkWritePermission(this.density);
        if (ImplementationHelper.ensurePositive(DefaultMedium.class, "density", true, newValue)) {
            this.density = newValue;
        }
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getDensity"})
    @XmlElement(name="density", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Double> getDensities() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new AbstractSet<Double>(){

            @Override
            public int size() {
                return DefaultMedium.this.getDensity() != null ? 1 : 0;
            }

            @Override
            public Iterator<Double> iterator() {
                return CollectionsExt.singletonOrEmpty(DefaultMedium.this.getDensity()).iterator();
            }

            @Override
            public boolean add(Double newValue) {
                if (this.isEmpty()) {
                    DefaultMedium.this.setDensity(newValue);
                    return true;
                }
                LegacyPropertyAdapter.warnIgnoredExtraneous(Double.class, DefaultMedium.class, "setDensities");
                return false;
            }
        };
    }

    @Deprecated(since="1.0")
    public void setDensities(Collection<? extends Double> newValues) {
        this.setDensity(LegacyPropertyAdapter.getSingleton(newValues, Double.class, null, DefaultMedium.class, "setDensities"));
    }

    @XmlElement(name="densityUnits")
    public Unit<?> getDensityUnits() {
        return this.densityUnits;
    }

    public void setDensityUnits(Unit<?> newValue) {
        this.checkWritePermission(this.densityUnits);
        this.densityUnits = newValue;
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="volumes")
    public Integer getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Integer newValue) {
        this.checkWritePermission(this.volumes);
        if (ImplementationHelper.ensurePositive(DefaultMedium.class, "volumes", false, newValue)) {
            this.volumes = newValue;
        }
    }

    @XmlElement(name="mediumFormat")
    public Collection<MediumFormat> getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return this.mediumFormats;
    }

    public void setMediumFormats(Collection<? extends MediumFormat> newValues) {
        this.mediumFormats = this.writeCollection(newValues, this.mediumFormats, MediumFormat.class);
    }

    @XmlElement(name="mediumNote")
    public InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public void setMediumNote(InternationalString newValue) {
        this.checkWritePermission(this.mediumNote);
        this.mediumNote = newValue;
    }

    @Override
    @XmlElement(name="identifier")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/gmd")
    private MediumName getLegacyName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? MediumName.castOrWrap(this.name) : null;
    }

    private void setLegacyName(MediumName newValue) {
        this.name = newValue;
    }
}

