/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.util.CodeLists;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.DefaultInternationalString;
import org.apache.sis.util.Locales;
import org.apache.sis.util.ResourceInternationalString;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;
import org.opengis.util.ControlledVocabulary;
import org.opengis.util.InternationalString;

public final class Types
extends Static {
    private static final char SEPARATOR = '.';
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.metadata");
    private static Map<String, Object> typeForNames;

    private Types() {
    }

    public static String getStandardName(Class<?> type) {
        String id;
        UML uml;
        if (type != null && (uml = type.getAnnotation(UML.class)) != null && (id = uml.identifier()) != null && !id.isEmpty()) {
            return id.intern();
        }
        return null;
    }

    public static String getListName(ControlledVocabulary code) {
        if (code == null) {
            return null;
        }
        Class type = code instanceof Enum ? ((Enum)code).getDeclaringClass() : code.getClass();
        String id = Types.getStandardName(type);
        return id != null ? id : type.getSimpleName();
    }

    public static String getCodeName(ControlledVocabulary code) {
        if (code == null) {
            return null;
        }
        String id = code.identifier();
        return id != null && !id.isEmpty() ? id : code.name();
    }

    public static String getCodeLabel(ControlledVocabulary code) {
        if (code == null) {
            return null;
        }
        String id = code.identifier();
        String name = code.name();
        if (id == null) {
            id = name;
        }
        for (String candidate : code.names()) {
            if (candidate.equals(name) || candidate.length() < id.length()) continue;
            id = candidate;
        }
        return CharSequences.camelCaseToSentence(id).toString();
    }

    public static InternationalString getCodeTitle(ControlledVocabulary code) {
        return code != null ? new CodeTitle(code) : null;
    }

    public static InternationalString getDescription(ControlledVocabulary code) {
        String resources;
        if (code != null && (resources = Types.getResources(code.getClass().getName())) != null) {
            return new Description(resources, Description.resourceKey(code));
        }
        return null;
    }

    public static InternationalString getDescription(Class<?> type) {
        String resources;
        String name = Types.getStandardName(type);
        if (name != null && (resources = Types.getResources(type.getName())) != null) {
            return new Description(resources, name);
        }
        return null;
    }

    public static InternationalString getDescription(Class<?> type, String property) {
        String resources;
        String name;
        if (property != null && (name = Types.getStandardName(type)) != null && (resources = Types.getResources(type.getName())) != null) {
            return new Description(resources, name + "." + property);
        }
        return null;
    }

    static String getResources(String classname) {
        String resources = "org.opengis.metadata.Descriptions";
        if (classname.regionMatches(0, resources, 0, 21)) {
            return resources;
        }
        return null;
    }

    public static <T extends ControlledVocabulary> T[] getCodeValues(Class<T> codeType) {
        return CodeLists.values(codeType);
    }

    public static synchronized Class<?> forStandardName(String identifier) {
        Class<?> type;
        Object value;
        if (identifier == null) {
            return null;
        }
        if (typeForNames == null) {
            Class<UML> c = UML.class;
            InputStream in = c.getResourceAsStream("class-index.properties");
            if (in == null) {
                throw new MissingResourceException("class-index.properties", c.getName(), identifier);
            }
            Properties props = new Properties();
            try {
                props.load(in);
                in.close();
            }
            catch (IOException | IllegalArgumentException e) {
                throw new BackingStoreException(e);
            }
            typeForNames = new HashMap<String, Object>(Containers.hashMapCapacity(2 * props.size()));
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String key = ((String)e.getKey()).intern();
                String value2 = ((String)e.getValue()).intern();
                typeForNames.put(key, value2);
                if (key.length() <= 3 || key.charAt(2) != '_' || !Character.isUpperCase(key.charAt(1))) continue;
                typeForNames.putIfAbsent(key.substring(3).intern(), value2);
            }
            typeForNames.putIfAbsent("MI_SensorTypeCode", "org.apache.sis.internal.jaxb.metadata.replace.SensorType");
        }
        if ((value = typeForNames.get(identifier)) == null || value instanceof Class) {
            return (Class)value;
        }
        try {
            type = Class.forName((String)value);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException((String)value, e);
        }
        typeForNames.put(identifier.intern(), type);
        return type;
    }

    public static <T extends Enum<T>> T forEnumName(Class<T> enumType, String name) {
        return CodeLists.forName(enumType, name);
    }

    public static <T extends CodeList<T>> T forCodeName(Class<T> codeType, String name, boolean canCreate) {
        return CodeLists.forName(codeType, name, canCreate);
    }

    public static ControlledVocabulary forCodeTitle(CharSequence title) {
        return title instanceof CodeTitle ? ((CodeTitle)((Object)title)).code : null;
    }

    public static InternationalString toInternationalString(Map<String, ?> properties, String prefix) throws IllegalArgumentException {
        SortedMap sorted;
        ArgumentChecks.ensureNonEmpty("prefix", prefix);
        if (properties == null) {
            return null;
        }
        boolean isSorted = false;
        if (properties instanceof SortedMap && (sorted = (SortedMap)properties).comparator() == null) {
            properties = sorted.tailMap(prefix);
            isSorted = true;
        }
        Object i18n = null;
        Locale firstLocale = null;
        DefaultInternationalString dis = null;
        int offset = prefix.length();
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value;
            Locale locale;
            String key = entry.getKey();
            if (key == null) continue;
            if (!key.startsWith(prefix)) {
                if (!isSorted) continue;
                break;
            }
            if (key.length() == offset) {
                locale = Locale.ROOT;
            } else {
                char c = key.charAt(offset);
                if (c != '_') {
                    if (!isSorted || c <= '_') continue;
                    break;
                }
                int s = offset + 1;
                try {
                    locale = Locales.parse(key, s);
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException(Errors.getResources(properties).getString((short)54, "(" + key.substring(0, s) + "\uff09" + key.substring(s), e));
                }
            }
            if ((value = entry.getValue()) == null) continue;
            if (!(value instanceof CharSequence)) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)58, key, value.getClass()));
            }
            if (i18n == null) {
                i18n = (CharSequence)value;
                firstLocale = locale;
                continue;
            }
            if (dis == null) {
                dis = new DefaultInternationalString();
                Types.add(dis, firstLocale, (CharSequence)i18n);
                i18n = dis;
            }
            Types.add(dis, locale, (CharSequence)value);
        }
        return Types.toInternationalString(i18n);
    }

    private static void add(DefaultInternationalString dis, Locale locale, CharSequence string) {
        boolean i18n = string instanceof InternationalString;
        dis.add(locale, i18n ? ((InternationalString)string).toString(locale) : string.toString());
        if (i18n && !(string instanceof SimpleInternationalString)) {
            LogRecord record = Messages.getResources(null).getLogRecord(Level.WARNING, (short)25);
            Logging.completeAndLog(LOGGER, Types.class, "toInternationalString", record);
        }
    }

    public static InternationalString toInternationalString(CharSequence string) {
        if (string == null || string instanceof InternationalString) {
            return (InternationalString)string;
        }
        return new SimpleInternationalString(string.toString());
    }

    public static InternationalString[] toInternationalStrings(CharSequence ... strings) {
        if (strings == null || strings instanceof InternationalString[]) {
            return (InternationalString[])strings;
        }
        InternationalString[] copy = new InternationalString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            copy[i] = Types.toInternationalString(strings[i]);
        }
        return copy;
    }

    public static String toString(InternationalString i18n, Locale locale) {
        return i18n == null ? null : (locale == null ? i18n.toString() : i18n.toString(locale));
    }

    private static final class CodeTitle
    extends Description {
        private static final long serialVersionUID = 3306532357801489365L;
        final ControlledVocabulary code;

        CodeTitle(ControlledVocabulary code) {
            super("org.opengis.metadata.CodeLists", CodeTitle.resourceKey(code));
            this.code = code;
        }

        @Override
        String fallback() {
            return Types.getCodeLabel(this.code);
        }
    }

    private static class Description
    extends ResourceInternationalString {
        private static final long serialVersionUID = -6202647167398898834L;
        private static final ClassLoader CLASSLOADER = UML.class.getClassLoader();

        Description(String resources, String key) {
            super(resources, key);
        }

        @Override
        protected final ResourceBundle getBundle(Locale locale) {
            return ResourceBundle.getBundle(this.resources, locale, CLASSLOADER);
        }

        @Override
        public final String toString(Locale locale) {
            try {
                return super.toString(locale);
            }
            catch (MissingResourceException e) {
                Logging.ignorableException(Messages.LOGGER, ResourceInternationalString.class, "toString", e);
                return this.fallback();
            }
        }

        String fallback() {
            return CharSequences.camelCaseToSentence(this.key.substring(this.key.lastIndexOf(46) + 1)).toString();
        }

        static String resourceKey(ControlledVocabulary code) {
            Object key = Types.getCodeName(code);
            if (((String)key).indexOf(46) < 0) {
                key = Types.getListName(code) + "." + (String)key;
            }
            return key;
        }
    }
}

