/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;

public final class TransformedShape
extends AffineTransform
implements Shape {
    private static final long serialVersionUID = 3541606381365714951L;
    private Shape shape;
    private transient Point2D.Double point;
    private transient Rectangle2D.Double rectangle;

    public TransformedShape() {
        this.initTransientFields();
    }

    public TransformedShape(AffineTransform transform) {
        super(transform);
        this.initTransientFields();
    }

    public TransformedShape(Shape shape) {
        ArgumentChecks.ensureNonNull((String)"shape", (Object)shape);
        this.shape = shape;
        this.initTransientFields();
    }

    public TransformedShape(Shape shape, AffineTransform transform) {
        super(transform);
        ArgumentChecks.ensureNonNull((String)"shape", (Object)shape);
        this.shape = shape;
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.point = new Point2D.Double();
        this.rectangle = new Rectangle2D.Double();
    }

    public Shape getOriginalShape() {
        return this.shape;
    }

    public void setOriginalShape(Shape shape) {
        ArgumentChecks.ensureNonNull((String)"shape", (Object)shape);
        this.shape = shape;
    }

    public void getMatrix(float[] matrix, int offset) {
        matrix[offset] = (float)this.getScaleX();
        matrix[++offset] = (float)this.getShearY();
        matrix[++offset] = (float)this.getShearX();
        matrix[++offset] = (float)this.getScaleY();
        matrix[++offset] = (float)this.getTranslateX();
        matrix[++offset] = (float)this.getTranslateY();
    }

    public void setTransform(float[] matrix, int offset) {
        this.setTransform(matrix[offset], matrix[++offset], matrix[++offset], matrix[++offset], matrix[++offset], matrix[++offset]);
    }

    @Override
    public boolean contains(double x, double y) {
        Point2D.Double p = this.point;
        p.x = x;
        p.y = y;
        return this.contains(p);
    }

    @Override
    public boolean contains(Point2D p) {
        try {
            return this.shape.contains(this.inverseTransform(p, this.point));
        }
        catch (NoninvertibleTransformException exception) {
            Logging.recoverableException(null, TransformedShape.class, (String)"contains", (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean contains(double x, double y, double width, double height) {
        Rectangle2D.Double r = this.rectangle;
        r.x = x;
        r.y = y;
        r.width = width;
        r.height = height;
        return this.contains(r);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        try {
            return this.shape.contains(AffineTransforms2D.inverseTransform((AffineTransform)this, (Rectangle2D)r, (Rectangle2D)this.rectangle));
        }
        catch (NoninvertibleTransformException exception) {
            Logging.recoverableException(null, TransformedShape.class, (String)"contains", (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        Rectangle2D.Double r = this.rectangle;
        r.x = x;
        r.y = y;
        r.width = width;
        r.height = height;
        return this.intersects(r);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        try {
            return this.shape.intersects(AffineTransforms2D.inverseTransform((AffineTransform)this, (Rectangle2D)r, (Rectangle2D)this.rectangle));
        }
        catch (NoninvertibleTransformException exception) {
            Logging.recoverableException(null, TransformedShape.class, (String)"intersects", (Throwable)exception);
            return true;
        }
    }

    @Override
    public Rectangle getBounds() {
        return (Rectangle)AffineTransforms2D.transform((AffineTransform)this, (Rectangle2D)this.shape.getBounds2D(), (Rectangle2D)new Rectangle());
    }

    @Override
    public Rectangle2D getBounds2D() {
        return AffineTransforms2D.transform((AffineTransform)this, (Rectangle2D)this.shape.getBounds2D(), null);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        if (!this.isIdentity()) {
            if (at == null || at.isIdentity()) {
                return this.shape.getPathIterator(this);
            }
            at = new AffineTransform(at);
            at.concatenate(this);
        }
        return this.shape.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        if (!this.isIdentity()) {
            if (at == null || at.isIdentity()) {
                return this.shape.getPathIterator(this, flatness);
            }
            at = new AffineTransform(at);
            at.concatenate(this);
        }
        return this.shape.getPathIterator(at, flatness);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() ^ 0x578F6007;
        if (this.shape != null) {
            code ^= this.shape.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TransformedShape && super.equals(object)) {
            return Objects.equals(this.shape, ((TransformedShape)object).shape);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readObject();
        this.initTransientFields();
    }
}

