/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;

public final class InternalUtilities
extends Static {
    public static final double COMPARISON_THRESHOLD = 1.0E-14;
    public static final double LINEAR_TOLERANCE = 1.0;
    public static final double ANGULAR_TOLERANCE = 8.999280057595392E-6;
    private static final double EPS = 1.0E-8;
    private static final int ULP_TOLERANCE = 4;

    private InternalUtilities() {
    }

    public static boolean epsilonEqual(double v1, double v2, ComparisonMode mode) {
        switch (mode) {
            default: {
                return Utilities.equals(v1, v2);
            }
            case APPROXIMATE: {
                return InternalUtilities.epsilonEqual(v1, v2);
            }
            case DEBUG: 
        }
        boolean equal = InternalUtilities.epsilonEqual(v1, v2);
        assert (equal) : "v1=" + v1 + " v2=" + v2 + " \u0394v=" + Math.abs(v1 - v2);
        return equal;
    }

    public static boolean epsilonEqual(double v1, double v2) {
        double threshold = 1.0E-14 * Math.max(Math.abs(v1), Math.abs(v2));
        if (threshold == Double.POSITIVE_INFINITY || Double.isNaN(threshold)) {
            return Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
        }
        return Math.abs(v1 - v2) <= threshold;
    }

    public static boolean debugEquals(Object o1, Object o2) throws AssertionError {
        return org.apache.sis.util.Utilities.deepEquals((Object)o1, (Object)o2, (ComparisonMode)ComparisonMode.DEBUG);
    }

    public static double adjustForRoundingError(double value, double scale, int maxULP) {
        double target = Math.rint(value * (scale = Math.abs(scale))) / scale;
        return Math.abs(value - target) <= (double)maxULP * Math.ulp(value) ? target : value;
    }

    public static double adjustForRoundingError(double value) {
        return InternalUtilities.adjustForRoundingError(value, 360.0, 4);
    }

    public static void configure(NumberFormat format, double value, int maxPrecision) {
        double check;
        int precision;
        value = Math.abs(value);
        if (format instanceof DecimalFormat) {
            value *= (double)((DecimalFormat)format).getMultiplier();
        }
        for (precision = 0; precision < maxPrecision && (check = Math.rint(value * 10000.0) % 10000.0) > value * 1.0E-8; ++precision) {
            value *= 10.0;
        }
        format.setMinimumFractionDigits(precision);
        format.setMaximumFractionDigits(precision);
    }

    public static int parseColor(String color) throws NumberFormatException {
        if ((color = color.trim()).startsWith("#")) {
            String code = color.substring(1);
            int value = (int)Long.parseLong(code, 16);
            switch (code.length()) {
                case 3: {
                    value |= 0xF000;
                }
                case 4: {
                    int t = value & 0xF000;
                    int n = (t | t << 4) << 12;
                    t = value & 0xF00;
                    int n2 = n | (t | t << 4) << 8;
                    t = value & 0xF0;
                    int n3 = n2 | (t | t << 4) << 4;
                    t = value & 0xF;
                    return n3 | (t | t << 4);
                }
                case 6: {
                    value |= 0xFF000000;
                }
                case 8: {
                    return value;
                }
            }
        } else {
            long n = Long.decode(color);
            int value = (int)n;
            if ((long)value == n) {
                if ((value & 0xFF000000) == 0) {
                    value |= 0xFF000000;
                }
                return value;
            }
        }
        throw new NumberFormatException(Errors.format((short)53, "color", color));
    }
}

