/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

public enum OS {
    UNKNOWN(false),
    WINDOWS(false),
    MAC_OS(true),
    LINUX(true);

    public final boolean unix;

    private OS(boolean unix) {
        this.unix = unix;
    }

    public static String uname() {
        try {
            return System.getProperty("os.name");
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static OS current() {
        String name = OS.uname();
        if (name != null) {
            if (name.contains("Windows")) {
                return WINDOWS;
            }
            if (name.contains("Mac OS")) {
                return MAC_OS;
            }
            if (name.contains("Linux")) {
                return LINUX;
            }
        }
        return UNKNOWN;
    }
}

