/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengis.util.FactoryException;

final class FactoryMethod {
    static final FactoryMethod NULL = new FactoryMethod(null, null);
    private final Method method;
    private final Object factory;

    private FactoryMethod(Method method, Object factory) {
        this.method = method;
        this.factory = factory;
    }

    static FactoryMethod find(Class<?> type, Object[] factories) {
        for (Object factory : factories) {
            for (Method method : factory.getClass().getMethods()) {
                Type mapType;
                Type[] types;
                String name;
                if (method.isSynthetic() || method.isAnnotationPresent(Deprecated.class) || !(name = method.getName()).startsWith("create") || !type.isAssignableFrom(method.getReturnType()) || (types = method.getGenericParameterTypes()).length == 0 || (mapType = types[0]) == Map.class || !(mapType instanceof ParameterizedType) || (types = ((ParameterizedType)mapType).getActualTypeArguments()).length != 2 || !FactoryMethod.bounds(types[0]).isAssignableFrom(String.class) || !FactoryMethod.bounds(types[1]).isAssignableFrom(Object.class)) continue;
                return new FactoryMethod(method, factory);
            }
        }
        return null;
    }

    private static Class<?> bounds(Type type) {
        while (type instanceof WildcardType) {
            Type[] types = ((WildcardType)type).getUpperBounds();
            if (types.length != 1) continue;
            type = types[0];
        }
        return (Class)type;
    }

    Object create(Map<String, ?> properties) throws FactoryException {
        if (this.method == null) {
            return null;
        }
        Class<?>[] types = this.method.getParameterTypes();
        Object[] parameters = new Object[types.length];
        if (types.length > 1) {
            LinkedHashMap reduced = new LinkedHashMap(properties);
            properties = reduced;
            block3: for (int i = 1; i < types.length; ++i) {
                Class<?> expected = types[i];
                Iterator it = reduced.values().iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    if (!expected.isInstance(value)) continue;
                    parameters[i] = value;
                    it.remove();
                    continue block3;
                }
            }
        }
        parameters[0] = properties;
        try {
            return this.method.invoke(this.factory, parameters);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(cause.getLocalizedMessage(), cause);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof FactoryMethod) {
            FactoryMethod that = (FactoryMethod)other;
            return this.method.equals(that.method) && this.factory == that.factory;
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() ^ System.identityHashCode(this.factory);
    }
}

