/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.process;

import java.util.EventObject;
import org.apache.sis.util.iso.Types;
import org.geotoolkit.process.Process;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public class ProcessEvent
extends EventObject {
    private static final long serialVersionUID = 622026012845207483L;
    private final InternationalString task;
    private final float progress;
    private final ParameterValueGroup output;
    private final Exception exception;

    public ProcessEvent(Process source) {
        super(source);
        this.progress = Float.NaN;
        this.task = null;
        this.exception = null;
        this.output = null;
    }

    public ProcessEvent(Process source, CharSequence task, float progress) {
        super(source);
        this.progress = progress;
        this.task = Types.toInternationalString((CharSequence)task);
        this.exception = null;
        this.output = null;
    }

    public ProcessEvent(Process source, CharSequence task, float progress, ParameterValueGroup output) {
        super(source);
        this.progress = progress;
        this.task = Types.toInternationalString((CharSequence)task);
        this.exception = null;
        this.output = output;
    }

    public ProcessEvent(Process source, CharSequence task, float progress, Exception exception) {
        super(source);
        this.progress = progress;
        this.task = Types.toInternationalString((CharSequence)task);
        this.exception = exception;
        this.output = null;
    }

    @Override
    public Process getSource() {
        return (Process)super.getSource();
    }

    public InternationalString getTask() {
        return this.task;
    }

    public float getProgress() {
        return this.progress;
    }

    public ParameterValueGroup getOutput() {
        return this.output;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append("[source=").append(this.source);
        if (this.task != null) {
            buffer.append(", task=\"").append((CharSequence)this.task).append('\"');
        }
        if (!Float.isNaN(this.progress)) {
            buffer.append(", progress=").append(this.progress).append('%');
        }
        return buffer.append(']').toString();
    }
}

