/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.Date;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.geotoolkit.resources.Errors;

public class DateRange
extends Range<Date> {
    private static final long serialVersionUID = -6400011350250757942L;

    public DateRange(Date startTime, Date endTime) {
        super(Date.class, (Comparable)DateRange.clone(startTime), true, (Comparable)DateRange.clone(endTime), true);
    }

    public DateRange(Date startTime, boolean isMinIncluded, Date endTime, boolean isMaxIncluded) {
        super(Date.class, (Comparable)DateRange.clone(startTime), isMinIncluded, (Comparable)DateRange.clone(endTime), isMaxIncluded);
    }

    public DateRange(MeasurementRange<?> range, Date origin) throws IncommensurableException {
        this(range, DateRange.getConverter(range.unit()), origin.getTime());
    }

    private DateRange(MeasurementRange<?> range, UnitConverter converter, long origin) throws IncommensurableException {
        super(Date.class, (Comparable)new Date(origin + Math.round(converter.convert(range.getMinDouble()))), range.isMinIncluded(), (Comparable)new Date(origin + Math.round(converter.convert(range.getMaxDouble()))), range.isMaxIncluded());
    }

    private static DateRange cast(Range<?> range) {
        if (range == null || range instanceof DateRange) {
            return (DateRange)range;
        }
        return new DateRange((Date)range.getMinValue(), range.isMinIncluded(), (Date)range.getMaxValue(), range.isMaxIncluded());
    }

    private static Date clone(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    private static UnitConverter getConverter(Unit<?> source) throws IncommensurableException {
        if (source == null) {
            throw new IncommensurableException(Errors.format((short)128));
        }
        return source.getConverterToAny(Units.MILLISECOND);
    }

    public Date getMinValue() {
        return DateRange.clone((Date)super.getMinValue());
    }

    public Date getMaxValue() {
        return DateRange.clone((Date)super.getMaxValue());
    }

    public DateRange union(Range<Date> range) throws IllegalArgumentException {
        return DateRange.cast(super.union(range));
    }

    public DateRange intersect(Range<Date> range) throws IllegalArgumentException {
        return DateRange.cast(super.intersect(range));
    }

    public DateRange[] subtract(Range<Date> range) throws IllegalArgumentException {
        Range[] ranges = super.subtract(range);
        DateRange[] result = new DateRange[ranges.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = DateRange.cast(ranges[i]);
        }
        return result;
    }
}

