/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.StringBuilders;

public final class StringUtilities {
    public static final String TREE_BLANK = "\u00a0\u00a0\u00a0\u00a0";
    public static final String TREE_LINE = "\u00a0\u00a0\u2502\u00a0";
    public static final String TREE_CROSS = "\u00a0\u00a0\u251c\u2500";
    public static final String TREE_END = "\u00a0\u00a0\u2514\u2500";
    private static final String START = "\u001b[";
    private static final char END = 'm';
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    private StringUtilities() {
    }

    public static String MD5encode(String key) {
        byte[] uniqueKey = key.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("no MD5 support in this VM");
        }
        StringBuffer hashString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }

    public static String clean(String s) {
        s = s.trim();
        s = s.replace("\t", "");
        s = s.replace("\n", "");
        s = s.replace("\r", "");
        return s;
    }

    public static List<String> cleanCharSequences(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            s = s.replace(" ", "");
            s = s.replace("\t", "");
            s = s.replace("\n", "");
            result.add(s);
        }
        return result;
    }

    public static boolean containsIgnoreCase(List<String> list, String str) {
        boolean strAvailable = false;
        if (list != null) {
            for (String s : list) {
                if (!s.equalsIgnoreCase(str)) continue;
                strAvailable = true;
                break;
            }
        }
        return strAvailable;
    }

    public static String firstToUpper(String s) {
        if (s != null && !s.isEmpty()) {
            String first = s.substring(0, 1);
            Object result = s.substring(1);
            result = first.toUpperCase() + (String)result;
            return result;
        }
        return s;
    }

    public static int[] getIndexes(String s, char occ) {
        int pos = s.indexOf(occ);
        if (pos < 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] indexes = new int[]{pos};
        pos = s.indexOf(occ, pos + 1);
        while (pos >= 0) {
            int end = indexes.length;
            indexes = ArraysExt.resize((int[])indexes, (int)(end + 1));
            indexes[end] = pos;
            pos = s.indexOf(occ, pos + 1);
        }
        return indexes;
    }

    public static String htmlEncodeSpecialChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u007f') {
                sb.append("&#").append((int)c).append(";");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean matchesStringfromList(List<String> list, String str) {
        boolean strAvailable = false;
        for (String s : list) {
            Pattern pattern = Pattern.compile(str, 130);
            Matcher matcher = pattern.matcher(s);
            if (!matcher.find()) continue;
            strAvailable = true;
        }
        return strAvailable;
    }

    public static String replacePrefix(String s, String localPart, String prefix) {
        return s.replaceAll("[a-zA-Z0-9]*:" + localPart, prefix + ":" + localPart);
    }

    @Deprecated
    public static String removeXmlns(String xml) {
        String s = xml;
        s = s.replaceAll("xmlns=\"[^\"]*\" ", "");
        s = s.replaceAll("xmlns=\"[^\"]*\"", "");
        s = s.replaceAll("xmlns:[^=]*=\"[^\"]*\" ", "");
        s = s.replaceAll("xmlns:[^=]*=\"[^\"]*\"", "");
        return s;
    }

    public static String removePrefix(String s) {
        int i = s.indexOf(58);
        if (i != -1) {
            s = s.substring(i + 1, s.length());
        }
        return s;
    }

    public static String toCommaSeparatedValues(Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object obj : values) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(obj);
        }
        return builder.toString();
    }

    public static String toCommaSeparatedValues(Object ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(values[i]);
        }
        return builder.toString();
    }

    public static List<String> toStringList(String commaSeparatedString) {
        return StringUtilities.toStringList(commaSeparatedString, ',');
    }

    @Deprecated
    public static List<String> toStringList(String toSplit, char separator) {
        if (toSplit == null) {
            return Collections.emptyList();
        }
        ArrayList<String> strings = new ArrayList<String>();
        int last = 0;
        toSplit = toSplit.trim();
        int i = toSplit.indexOf(separator);
        while (i >= 0) {
            strings.add(toSplit.substring(last, i).trim());
            last = ++i;
            i = toSplit.indexOf(separator, i);
        }
        strings.add(toSplit.substring(last).trim());
        return strings;
    }

    public static String toString(Iterable<?> collection, String separator) {
        ArgumentChecks.ensureNonNull((String)"separator", (Object)separator);
        String list = null;
        if (collection != null) {
            StringBuilder buffer = null;
            for (Object element : collection) {
                if (element == null) continue;
                if (list == null) {
                    list = element.toString();
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(list);
                }
                buffer.append(separator);
                if (element instanceof CharSequence) {
                    buffer.append((CharSequence)element);
                    continue;
                }
                buffer.append(element);
            }
            if (buffer != null) {
                list = buffer.toString();
            }
        }
        return list;
    }

    public static String transformCodeName(String code) {
        StringBuilder result = new StringBuilder();
        while (code.indexOf(95) != -1) {
            String tmp = code.substring(0, code.indexOf(95)).toLowerCase();
            result.append(StringUtilities.firstToUpper(tmp));
            code = code.substring(code.indexOf(95) + 1, code.length());
        }
        code = code.toLowerCase();
        result.append(StringUtilities.firstToUpper(code));
        return result.toString();
    }

    public static String toStringTree(Object ... objects) {
        return StringUtilities.toStringTree("", Arrays.asList(objects));
    }

    public static String toStringTree(String root, Iterable<?> objects) {
        StringBuilder sb = new StringBuilder();
        if (root != null) {
            sb.append(root);
        }
        if (objects != null) {
            Iterator<?> ite = objects.iterator();
            while (ite.hasNext()) {
                sb.append('\n');
                Object next = ite.next();
                boolean last = !ite.hasNext();
                sb.append(last ? "\u2514\u2500 " : "\u251c\u2500 ");
                String[] parts = String.valueOf(next).split("\n");
                sb.append(parts[0]);
                for (int k = 1; k < parts.length; ++k) {
                    sb.append('\n');
                    sb.append(last ? (char)' ' : '\u2502');
                    sb.append("  ");
                    sb.append(parts[k]);
                }
            }
        }
        return sb.toString();
    }

    public static String X364toHTML(String text) {
        StringBuilder buffer = new StringBuilder(text);
        StringBuilders.replace((StringBuilder)buffer, (String)"&", (String)"&amp;");
        StringBuilders.replace((StringBuilder)buffer, (String)"<", (String)"&lt;");
        StringBuilders.replace((StringBuilder)buffer, (String)">", (String)"&gt;");
        boolean fontApplied = false;
        StringBuilder tmp = null;
        int i = buffer.indexOf(START);
        while (i >= 0) {
            block17: {
                String color;
                int code;
                int lower;
                int upper = lower = i + START.length();
                int length = buffer.length();
                while (upper < length && buffer.charAt(upper++) != 'm') {
                }
                try {
                    code = Integer.parseInt(buffer.substring(lower, upper - 1));
                }
                catch (NumberFormatException e) {
                    buffer.delete(i, upper);
                    break block17;
                }
                switch (code) {
                    case 31: {
                        color = "red";
                        break;
                    }
                    case 32: {
                        color = "green";
                        break;
                    }
                    case 33: {
                        color = "olive";
                        break;
                    }
                    case 34: {
                        color = "blue";
                        break;
                    }
                    case 35: {
                        color = "magenta";
                        break;
                    }
                    case 36: {
                        color = "teal";
                        break;
                    }
                    case 37: {
                        color = "gray";
                        break;
                    }
                    case 0: 
                    case 39: {
                        color = null;
                        break;
                    }
                    default: {
                        buffer.delete(i, upper);
                        break block17;
                    }
                }
                if (tmp == null) {
                    tmp = new StringBuilder(24);
                }
                if (fontApplied) {
                    tmp.append("</font>");
                    fontApplied = false;
                }
                if (color != null) {
                    tmp.append("<font color=\"").append(color).append("\">");
                    fontApplied = true;
                }
                buffer.replace(i, upper, tmp.toString());
                tmp.setLength(0);
            }
            i = buffer.indexOf(START, i);
        }
        String result = buffer.toString();
        return result.equals(text) ? text : result;
    }
}

