/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.grid;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import org.geotoolkit.util.grid.GridTraversal;

class MonoDimensionMove
implements Spliterator<double[]> {
    private final int dimension;
    private double[] startPoint;
    private final DoubleUnaryOperator moveDir;
    private double distanceLeft;
    boolean hasNext = true;

    public MonoDimensionMove(int dimension, double[] startPoint, double distanceLeft) {
        this.dimension = dimension;
        this.startPoint = Arrays.copyOf(startPoint, startPoint.length);
        this.distanceLeft = distanceLeft;
        this.moveDir = distanceLeft < 0.0 ? GridTraversal::floorOrDecrement : GridTraversal::ceilOrIncrement;
    }

    @Override
    public boolean tryAdvance(Consumer<? super double[]> consumer) {
        if (!this.hasNext || GridTraversal.isNearZero(this.distanceLeft)) {
            return false;
        }
        double start = this.startPoint[this.dimension];
        double nextPos = this.moveDir.applyAsDouble(start);
        double dist = nextPos - start;
        if (Math.abs(dist) > Math.abs(this.distanceLeft)) {
            nextPos = start + this.distanceLeft;
            this.hasNext = false;
        }
        this.distanceLeft -= dist;
        double[] nextPoint = new double[this.startPoint.length];
        System.arraycopy(this.startPoint, 0, nextPoint, 0, this.startPoint.length);
        nextPoint[this.dimension] = nextPos;
        consumer.accept((double[])nextPoint);
        this.startPoint = nextPoint;
        return true;
    }

    @Override
    public Spliterator<double[]> trySplit() {
        if (this.distanceLeft < 3.0) {
            return null;
        }
        double cutDistance = this.distanceLeft / 2.0;
        double cutNearestInt = Math.floor(this.startPoint[this.dimension] + cutDistance);
        cutDistance = this.distanceLeft - (cutNearestInt - this.startPoint[this.dimension]);
        this.distanceLeft -= cutDistance;
        double[] splitStart = Arrays.copyOf(this.startPoint, this.startPoint.length);
        splitStart[this.dimension] = cutNearestInt;
        MonoDimensionMove prefix = new MonoDimensionMove(this.dimension, this.startPoint, this.distanceLeft);
        this.startPoint = splitStart;
        this.distanceLeft = cutDistance;
        return prefix;
    }

    @Override
    public long estimateSize() {
        return (long)Math.ceil(Math.abs(this.distanceLeft));
    }

    @Override
    public int characteristics() {
        return 273;
    }
}

