/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DefaultEvaluator;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class BufferedGridCoverage
extends GridCoverage {
    protected final DataBuffer data;
    private final Cache<GridExtent, RenderedImage> cachedRenderings;

    public BufferedGridCoverage(GridGeometry domain, List<? extends SampleDimension> range, DataBuffer data) {
        super(domain, range);
        this.data = data;
        ArgumentChecks.ensureNonNull("data", data);
        int numBands = range.size();
        int numBanks = data.getNumBanks();
        if (numBanks != 1 && numBanks != numBands) {
            throw new IllegalArgumentException(Resources.format((short)40, numBanks, numBands));
        }
        GridExtent extent = domain.getExtent();
        long expectedSize = BufferedGridCoverage.getSampleCount(extent, numBands);
        long bufferSize = Math.multiplyFull(data.getSize(), numBanks);
        if (bufferSize < expectedSize) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < extent.getDimension(); ++i) {
                if (i != 0) {
                    b.append(" \u00d7 ");
                }
                b.append(extent.getSize(i));
            }
            throw new IllegalGridGeometryException(Resources.format((short)36, b, numBands, expectedSize - bufferSize));
        }
        this.cachedRenderings = new Cache();
    }

    public BufferedGridCoverage(GridGeometry grid, List<? extends SampleDimension> bands, int dataType) {
        super(grid, bands);
        int n = Math.toIntExact(BufferedGridCoverage.getSampleCount(grid.getExtent(), bands.size()));
        switch (dataType) {
            case 0: {
                this.data = new DataBufferByte(n);
                break;
            }
            case 2: {
                this.data = new DataBufferShort(n);
                break;
            }
            case 1: {
                this.data = new DataBufferUShort(n);
                break;
            }
            case 3: {
                this.data = new DataBufferInt(n);
                break;
            }
            case 4: {
                this.data = new DataBufferFloat(n);
                break;
            }
            case 5: {
                this.data = new DataBufferDouble(n);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((short)149, dataType));
            }
        }
        this.cachedRenderings = new Cache();
    }

    private static long getSampleCount(GridExtent extent, long nbSamples) {
        int i = extent.getDimension();
        while (--i >= 0) {
            nbSamples = Math.multiplyExact(nbSamples, extent.getSize(i));
        }
        return nbSamples;
    }

    @Override
    final DataType getBandType() {
        return DataType.forDataBufferType(this.data.getDataType());
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return new CellAccessor(this);
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        if (sliceExtent == null) {
            sliceExtent = this.gridGeometry.extent;
        }
        try {
            return this.cachedRenderings.computeIfAbsent(sliceExtent, slice -> {
                ImageRenderer renderer = new ImageRenderer(this, (GridExtent)slice);
                renderer.setData(this.data);
                return renderer.createImage();
            });
        }
        catch (IllegalGridGeometryException | MismatchedDimensionException e) {
            throw e;
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException e) {
            throw new CannotEvaluateException(e.getMessage(), (Throwable)e);
        }
    }

    protected void configure(ImageRenderer renderer) {
    }

    private static final class CellAccessor
    extends DefaultEvaluator {
        private final DataBuffer data;
        private final long[] lower;
        private final long[] sizes;
        private final boolean banded;

        CellAccessor(BufferedGridCoverage coverage) {
            super(coverage);
            GridExtent extent = coverage.getGridGeometry().getExtent();
            int numBands = coverage.getSampleDimensions().size();
            this.data = coverage.data;
            this.banded = this.data.getNumBanks() > 1;
            this.values = new double[numBands];
            this.lower = new long[extent.getDimension()];
            this.sizes = new long[this.lower.length + 1];
            this.sizes[0] = this.banded ? 1L : (long)numBands;
            for (int i = 0; i < this.lower.length; ++i) {
                this.lower[i] = extent.getLow(i);
                this.sizes[i + 1] = extent.getSize(i);
            }
        }

        @Override
        public double[] apply(DirectPosition point) throws CannotEvaluateException {
            int pos;
            int i;
            try {
                FractionalGridCoordinates.Position gc = this.toGridPosition(point);
                i = this.lower.length;
                long s = this.sizes[i];
                long index = 0L;
                while (--i >= 0) {
                    long low = this.lower[i];
                    long p = gc.getCoordinateValue(i);
                    if (p < low || (p -= low) >= s) {
                        if (this.isNullIfOutside()) {
                            return null;
                        }
                        throw new PointOutsideCoverageException(gc.pointOutsideCoverage(this.getCoverage().gridGeometry.extent), point);
                    }
                    s = this.sizes[i];
                    index = (index + p) * s;
                }
                pos = Math.toIntExact(index);
            }
            catch (ArithmeticException | TransformException | FactoryException ex) {
                throw new CannotEvaluateException(ex.getMessage(), ex);
            }
            double[] values = this.values;
            if (this.banded) {
                for (i = 0; i < values.length; ++i) {
                    values[i] = this.data.getElemDouble(i, pos);
                }
            } else {
                for (i = 0; i < values.length; ++i) {
                    values[i] = this.data.getElemDouble(i + pos);
                }
            }
            return values;
        }
    }
}

