/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import org.apache.sis.feature.PropertyView;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociation;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.util.GenericName;

class AssociationView
extends PropertyView<Feature>
implements FeatureAssociation {
    private static final long serialVersionUID = -148100967531766909L;
    private final FeatureAssociationRole role;

    private AssociationView(Feature feature, FeatureAssociationRole role) {
        super(feature, role.getName().toString());
        this.role = role;
    }

    static FeatureAssociation create(Feature feature, FeatureAssociationRole role) {
        if (AssociationView.isSingleton(role.getMaximumOccurs())) {
            return new Singleton(feature, role);
        }
        return new AssociationView(feature, role);
    }

    public final GenericName getName() {
        return this.role.getName();
    }

    public final FeatureAssociationRole getRole() {
        return this.role;
    }

    @Override
    final Class<Feature> getValueClass() {
        return Feature.class;
    }

    private static final class Singleton
    extends AssociationView {
        private static final long serialVersionUID = 2574475751526292380L;

        Singleton(Feature feature, FeatureAssociationRole role) {
            super(feature, role);
        }

        @Override
        public Feature getValue() {
            return (Feature)this.feature.getPropertyValue(this.name);
        }

        @Override
        public void setValue(Feature value) {
            this.feature.setPropertyValue(this.name, (Object)value);
        }

        @Override
        public Collection<Feature> getValues() {
            return Singleton.singletonOrEmpty(this.getValue());
        }
    }
}

