/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.xml.NilReason;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.NilOperator;
import org.opengis.filter.NullOperator;

class UnaryFunction<R, V>
extends Node {
    private static final long serialVersionUID = 2020526901451551162L;
    protected final Expression<R, ? extends V> expression;

    UnaryFunction(Expression<R, ? extends V> expression) {
        ArgumentChecks.ensureNonNull("expression", expression);
        this.expression = expression;
    }

    public final Class<? super R> getResourceClass() {
        return this.expression.getResourceClass();
    }

    public final List<Expression<R, ?>> getParameters() {
        return this.getExpressions();
    }

    public final List<Expression<R, ?>> getExpressions() {
        return List.of(this.expression);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getExpressions();
    }

    static final class IsNil<R>
    extends UnaryFunction<R, Object>
    implements NilOperator<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -7540765433296725888L;
        private final String nilReason;

        IsNil(Expression<R, ?> expression, String nilReason) {
            super(expression);
            this.nilReason = nilReason;
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new IsNil<R>(effective[0], this.nilReason);
        }

        public Optional<String> getNilReason() {
            return Optional.ofNullable(this.nilReason);
        }

        public boolean test(R object) {
            NilReason value = NilReason.forObject(this.expression.apply(object));
            if (value == null) {
                return false;
            }
            if (this.nilReason == null) {
                return true;
            }
            String explanation = NilReason.OTHER.equals(value) ? value.getOtherExplanation() : value.toString();
            return this.nilReason.equalsIgnoreCase(explanation);
        }
    }

    static final class IsNull<R>
    extends UnaryFunction<R, Object>
    implements NullOperator<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = 2960285515924533419L;

        IsNull(Expression<R, ?> expression) {
            super(expression);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new IsNull<R>(effective[0]);
        }

        @Override
        protected char symbol() {
            return '\u2205';
        }

        public boolean test(R object) {
            return this.expression.apply(object) == null;
        }
    }
}

