/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.jaxb.referencing.SC_CRS;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.SubTypes;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCompoundCS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ParametricCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;

@XmlType(name="CompoundCRSType")
@XmlRootElement(name="CompoundCRS")
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929287L;
    private List<? extends CoordinateReferenceSystem> components;
    private transient List<SingleCRS> singles;

    public DefaultCompoundCRS(Map<String, ?> properties, CoordinateReferenceSystem ... components) {
        super(properties, DefaultCompoundCRS.createCoordinateSystem(properties, components));
        this.setComponents(Arrays.asList(components));
        if (this.singles != this.components) {
            DefaultCompoundCRS.verify(properties, (CoordinateReferenceSystem[])this.singles.toArray(SingleCRS[]::new));
        }
    }

    private static void verify(Map<String, ?> properties, CoordinateReferenceSystem[] components) {
        boolean allTypes = false;
        int isProjected = 0;
        boolean isEllipsoidalHeight = false;
        for (CoordinateReferenceSystem component : components) {
            int type;
            if (component instanceof GeodeticCRS) {
                type = 1;
            } else if (component instanceof ProjectedCRS) {
                isProjected = 1;
                type = 1;
            } else {
                if (!(component instanceof VerticalCRS)) continue;
                isEllipsoidalHeight = ReferencingUtilities.isEllipsoidalHeight(((VerticalCRS)component).getDatum());
                type = 2;
            }
            if (allTypes != (allTypes |= type)) continue;
            throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)76, type));
        }
        if (isEllipsoidalHeight && allTypes & true) {
            throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)77, isProjected));
        }
    }

    private static CoordinateSystem createCoordinateSystem(Map<String, ?> properties, CoordinateReferenceSystem[] components) {
        ArgumentChecks.ensureNonNull("components", components);
        DefaultCompoundCRS.verify(properties, components);
        if (components.length < 2) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)127, 2, components.length));
        }
        CoordinateSystem[] cs = new CoordinateSystem[components.length];
        for (int i = 0; i < components.length; ++i) {
            CoordinateReferenceSystem crs = components[i];
            ArgumentChecks.ensureNonNullElement("components", i, crs);
            cs[i] = crs.getCoordinateSystem();
        }
        return new DefaultCompoundCS(cs);
    }

    protected DefaultCompoundCRS(CompoundCRS crs) {
        super((CoordinateReferenceSystem)crs);
        if (crs instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS that = (DefaultCompoundCRS)crs;
            this.components = that.components;
            this.singles = that.singles;
        } else {
            this.setComponents(crs.getComponents());
        }
    }

    public static DefaultCompoundCRS castOrCopy(CompoundCRS object) {
        return object == null || object instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)object : new DefaultCompoundCRS(object);
    }

    public Class<? extends CompoundCRS> getInterface() {
        return CompoundCRS.class;
    }

    @Override
    final Datum getDatum() {
        return null;
    }

    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    private void setComponents(List<? extends CoordinateReferenceSystem> crs) {
        this.components = this.setSingleComponents(crs) ? this.singles : UnmodifiableArrayList.wrap((CoordinateReferenceSystem[])crs.toArray(CoordinateReferenceSystem[]::new));
    }

    public List<SingleCRS> getSingleComponents() {
        return this.singles;
    }

    private boolean setSingleComponents(List<? extends CoordinateReferenceSystem> crs) {
        ArrayList flattened = new ArrayList(crs.size());
        boolean identical = ReferencingUtilities.getSingleComponents(crs, flattened);
        this.singles = UnmodifiableArrayList.wrap((SingleCRS[])flattened.toArray(SingleCRS[]::new));
        return identical;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class type;
        in.defaultReadObject();
        List<? extends CoordinateReferenceSystem> components = this.components;
        if (components instanceof CheckedContainer && (type = ((CheckedContainer)((Object)components)).getElementType()) == SingleCRS.class) {
            this.singles = components;
            return;
        }
        this.setSingleComponents(components);
    }

    static boolean isStandardCompliant(List<? extends CoordinateReferenceSystem> singles) {
        if (Containers.isNullOrEmpty(singles)) {
            return false;
        }
        int state = 0;
        block9: for (CoordinateReferenceSystem coordinateReferenceSystem : singles) {
            switch (state) {
                case 0: {
                    if (coordinateReferenceSystem instanceof GeodeticCRS || coordinateReferenceSystem instanceof ProjectedCRS || coordinateReferenceSystem instanceof EngineeringCRS) {
                        switch (coordinateReferenceSystem.getCoordinateSystem().getDimension()) {
                            case 2: {
                                state = 1;
                                continue block9;
                            }
                            case 3: {
                                state = 2;
                                continue block9;
                            }
                        }
                    }
                    return false;
                }
                case 1: {
                    if (coordinateReferenceSystem instanceof VerticalCRS || coordinateReferenceSystem instanceof ParametricCRS) {
                        state = 2;
                        continue block9;
                    }
                }
                case 2: {
                    if (!(coordinateReferenceSystem instanceof TemporalCRS)) break;
                    state = 3;
                    continue block9;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized DefaultCompoundCRS forConvention(AxesConvention convention) {
        ArgumentChecks.ensureNonNull("convention", convention);
        DefaultCompoundCRS crs = (DefaultCompoundCRS)this.getCached(convention);
        if (crs == null) {
            crs = this;
            boolean changed = false;
            boolean reorderCRS = convention.ordinal() <= AxesConvention.DISPLAY_ORIENTED.ordinal();
            List<SingleCRS> components = reorderCRS ? this.singles : this.components;
            CoordinateReferenceSystem[] newComponents = new CoordinateReferenceSystem[components.size()];
            for (int i = 0; i < newComponents.length; ++i) {
                CoordinateReferenceSystem component = (CoordinateReferenceSystem)components.get(i);
                AbstractCRS m = DefaultCompoundCRS.castOrCopy(component);
                if (m != (m = m.forConvention(convention))) {
                    component = m;
                    changed = true;
                }
                newComponents[i] = component;
            }
            if (changed) {
                if (reorderCRS) {
                    Arrays.sort(newComponents, SubTypes.BY_TYPE);
                }
                crs = new DefaultCompoundCRS(IdentifiedObjects.getProperties(this, "identifiers"), newComponents);
            }
            crs = (DefaultCompoundCRS)this.setCached(convention, crs);
        }
        return crs;
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        throw new AssertionError();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    return this.components.equals(((DefaultCompoundCRS)object).components);
                }
            }
            return Utilities.deepEquals(this.getComponents(), ((CompoundCRS)object).getComponents(), mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.components.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isStandardCompliant;
        List<CoordinateReferenceSystem> crs;
        boolean isWKT1;
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl = isWKT1 = convention.majorVersion() == 1;
        if (isWKT1 || convention == Convention.INTERNAL) {
            crs = this.getComponents();
            isStandardCompliant = true;
        } else {
            crs = this.getSingleComponents();
            isStandardCompliant = DefaultCompoundCRS.isStandardCompliant(crs);
        }
        for (CoordinateReferenceSystem element : crs) {
            formatter.newLine();
            formatter.append(WKTUtilities.toFormattable(element));
        }
        formatter.newLine();
        if (!isStandardCompliant) {
            formatter.setInvalidWKT(this, null);
        }
        return isWKT1 ? "Compd_CS" : "CompoundCRS";
    }

    private DefaultCompoundCRS() {
        this.components = List.of();
        this.singles = List.of();
    }

    @XmlJavaTypeAdapter(value=SC_CRS.class)
    @XmlElement(name="componentReferenceSystem", required=true)
    private CoordinateReferenceSystem[] getXMLComponents() {
        return (CoordinateReferenceSystem[])this.getSingleComponents().toArray(CoordinateReferenceSystem[]::new);
    }

    private void setXMLComponents(CoordinateReferenceSystem[] crs) {
        this.components = this.setSingleComponents(Arrays.asList(crs)) ? this.singles : UnmodifiableArrayList.wrap(crs);
        this.setCoordinateSystem("coordinateSystem", DefaultCompoundCRS.createCoordinateSystem(null, crs));
    }
}

