/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class ConformalProjection
extends NormalizedProjection {
    private static final long serialVersionUID = -292755890184138414L;
    static final double ECCENTRICITY_THRESHOLD = 0.16;
    private final boolean useIterations;
    private final double c2\u03c7;
    private final double c4\u03c7;
    private final double c6\u03c7;
    private final double c8\u03c7;

    ConformalProjection(Initializer initializer) {
        super(initializer, null);
        this.useIterations = this.eccentricity >= 0.16;
        double e2 = this.eccentricitySquared;
        double e4 = e2 * e2;
        double e6 = e2 * e4;
        double e8 = e4 * e4;
        this.c2\u03c7 = Math.fma(e2, 0.5, Math.fma(e4, 0.20833333333333334, Math.fma(e6, 0.025, e8 * -0.036210317460317464)));
        this.c4\u03c7 = Math.fma(e4, 0.2916666666666667, Math.fma(e6, 0.24166666666666667, e8 * 0.03467261904761905));
        this.c6\u03c7 = Math.fma(e6, 0.23333333333333334, e8 * 0.2892857142857143);
        this.c8\u03c7 = e8 * 0.21225198412698412;
    }

    ConformalProjection(ConformalProjection other) {
        super(null, other);
        this.useIterations = other.useIterations;
        this.c2\u03c7 = other.c2\u03c7;
        this.c4\u03c7 = other.c4\u03c7;
        this.c6\u03c7 = other.c6\u03c7;
        this.c8\u03c7 = other.c8\u03c7;
    }

    final double \u03c6(double rexp\u03a8) throws ProjectionException {
        double \u03c6 = 1.5707963267948966 - 2.0 * Math.atan(rexp\u03a8);
        double sin_2\u03c6 = Math.sin(2.0 * \u03c6);
        double cos_2\u03c6 = Math.cos(2.0 * \u03c6);
        \u03c6 = Math.fma(sin_2\u03c6, Math.fma(cos_2\u03c6, Math.fma(cos_2\u03c6, Math.fma(cos_2\u03c6, this.c8\u03c7, this.c6\u03c7), this.c4\u03c7), this.c2\u03c7), \u03c6);
        if (!this.useIterations) {
            return \u03c6;
        }
        double h\u212f = 0.5 * this.eccentricity;
        for (int it = 0; it < 18; ++it) {
            double \u212fsin\u03c6 = this.eccentricity * Math.sin(\u03c6);
            double \u0394\u03c6 = \u03c6 - (\u03c6 = 1.5707963267948966 - 2.0 * Math.atan(rexp\u03a8 * Math.pow((1.0 - \u212fsin\u03c6) / (1.0 + \u212fsin\u03c6), h\u212f)));
            if (Math.abs(\u0394\u03c6) > 3.926676682852614E-10) continue;
            return \u03c6;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    final double exp\u03a8(double \u03c6, double \u212fsin\u03c6) {
        return Math.tan(0.7853981633974483 + 0.5 * \u03c6) * Math.pow((1.0 - \u212fsin\u03c6) / (1.0 + \u212fsin\u03c6), 0.5 * this.eccentricity);
    }

    final double dy_d\u03c6(double sin\u03c6, double cos\u03c6) {
        return 1.0 / cos\u03c6 - this.eccentricitySquared * cos\u03c6 / (1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
    }
}

