/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = -8962688502524486475L;
    private static final int GRID_DIMENSION = 2;
    private final int dimension;
    private final Inverse inverse;

    protected <T extends Quantity<T>> InterpolatedTransform(DatumShiftGrid<T, T> grid) throws NoninvertibleMatrixException {
        super(grid.getParameterDescriptors(), grid);
        Unit normalized;
        if (!grid.isCellValueRatio()) {
            throw new IllegalArgumentException(Resources.format((short)25, "isCellValueRatio", Boolean.FALSE));
        }
        Unit<T> unit = grid.getTranslationUnit();
        if (unit != grid.getCoordinateUnit()) {
            throw new IllegalArgumentException(Resources.format((short)26, "translation", unit));
        }
        this.dimension = grid.getTranslationDimensions();
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.setMatrix(grid.getCoordinateToGrid().getMatrix());
        Unit unit2 = normalized = Units.isAngular(unit) ? Units.DEGREE : unit.getSystemUnit();
        if (!unit.equals((Object)normalized)) {
            Number scale = 1.0;
            Number offset = 0.0;
            Number[] coefficients = Units.coefficients(normalized.getConverterTo(unit));
            switch (coefficients != null ? coefficients.length : -1) {
                case 2: {
                    scale = coefficients[1];
                }
                case 1: {
                    offset = coefficients[0];
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Resources.format((short)54, normalized, unit));
                }
            }
            for (int j = 0; j < this.dimension; ++j) {
                normalize.convertBefore(j, scale, offset);
            }
        }
        MatrixSIS denormalize = normalize.inverse();
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).setMatrix(denormalize);
        grid.getParameterValues(this.context);
        this.inverse = this.createInverse();
    }

    public static <T extends Quantity<T>> MathTransform createGeodeticTransformation(MathTransformFactory factory, DatumShiftGrid<T, T> grid) throws FactoryException {
        InterpolatedTransform tr;
        ArgumentChecks.ensureNonNull("grid", grid);
        try {
            tr = grid.getTranslationDimensions() == 2 ? new InterpolatedTransform2D(grid) : new InterpolatedTransform(grid);
        }
        catch (NoninvertibleMatrixException e) {
            throw new FactoryException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
        return tr.context.completeTransform(factory, tr);
    }

    public final DatumShiftGrid<?, ?> getShiftGrid() {
        return this.grid;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        if (dstPts != null) {
            double[] vector = new double[this.dimension];
            this.grid.interpolateInCell(x, y, vector);
            if (this.dimension > 2) {
                System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, this.dimension - 2);
                int i = this.dimension;
                do {
                    int n = dstOff + --i;
                    dstPts[n] = dstPts[n] + vector[i];
                } while (i > 2);
            }
            dstPts[dstOff + 1] = y + vector[1];
            dstPts[dstOff] = x + vector[0];
        }
        if (!derivate) {
            return null;
        }
        return this.grid.derivativeInCell(x, y);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int inc = this.dimension;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, inc, dstOff, inc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * inc;
                    dstOff += (numPts - 1) * inc;
                    inc = -inc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * inc);
                    srcOff = 0;
                }
            }
        }
        double[] vector = new double[this.dimension];
        while (--numPts >= 0) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            this.grid.interpolateInCell(x, y, vector);
            if (this.dimension > 2) {
                System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, this.dimension - 2);
                int i = this.dimension;
                do {
                    int n = dstOff + --i;
                    dstPts[n] = dstPts[n] + vector[i];
                } while (i > 2);
            }
            dstPts[dstOff + 1] = y + vector[1];
            dstPts[dstOff] = x + vector[0];
            dstOff += inc;
            srcOff += inc;
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    Inverse createInverse() {
        return new Inverse(this);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        return super.equals(object, mode) && Objects.equals(this.grid, ((InterpolatedTransform)object).grid);
    }

    static class Inverse
    extends AbstractMathTransform.Inverse
    implements Serializable {
        private static final long serialVersionUID = 4335801994727826360L;
        private static final boolean DEBUG = false;
        private static final boolean SIMPLE = false;
        private static final int MAXIMUM_ITERATIONS = 36;
        private final InterpolatedTransform forward;
        private final double tolerance;

        Inverse(InterpolatedTransform forward) {
            this.forward = forward;
            this.tolerance = forward.grid.getCellPrecision();
            if (!(this.tolerance > 0.0)) {
                throw new IllegalArgumentException(Errors.format((short)165, "grid.cellPrecision", this.tolerance));
            }
        }

        @Override
        public MathTransform inverse() {
            return this.forward;
        }

        @Override
        public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            int dimension = this.forward.dimension;
            if (dstPts == null) {
                dstPts = new double[dimension];
                dstOff = 0;
            }
            this.transform(srcPts, srcOff, dstPts, dstOff, 1);
            if (derivate) {
                return Matrices.inverse(this.forward.derivative(new DirectPositionView.Double(dstPts, dstOff, dimension)));
            }
            return null;
        }

        @Override
        public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            int dimension;
            int inc = dimension = this.forward.dimension;
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, inc, dstOff, inc, numPts)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        srcOff += (numPts - 1) * inc;
                        dstOff += (numPts - 1) * inc;
                        inc = -inc;
                        break;
                    }
                    default: {
                        srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * inc);
                        srcOff = 0;
                    }
                }
            }
            double[] vector = new double[dimension + 4];
            while (--numPts >= 0) {
                double yi;
                double xi;
                block9: {
                    double x = xi = srcPts[srcOff];
                    double y = yi = srcPts[srcOff + 1];
                    double tol = this.tolerance;
                    int it = 36;
                    while (true) {
                        this.forward.grid.interpolateInCell(xi, yi, vector);
                        double tx = vector[0];
                        double ty = vector[1];
                        double m00 = vector[dimension];
                        double m01 = vector[dimension + 1];
                        double m10 = vector[dimension + 2];
                        double m11 = vector[dimension + 3];
                        double det = m00 * m11 - m01 * m10;
                        double ex = xi + tx - x;
                        double ey = yi + ty - y;
                        double dx = (ex * m11 - ey * m01) / det;
                        double dy = (ey * m00 - ex * m10) / det;
                        xi -= dx;
                        yi -= dy;
                        if (!(Math.abs(ex) > tol) && !(Math.abs(ey) > tol)) break block9;
                        if (--it >= 0) continue;
                        if (it != -1 || this.forward.grid.isCellInGrid(xi, yi)) break;
                        tol = 0.5;
                    }
                    throw new TransformException(Resources.format((short)46));
                }
                if (dimension > 2) {
                    System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, dimension - 2);
                    int i = dimension;
                    do {
                        int n = dstOff + --i;
                        dstPts[n] = dstPts[n] - vector[i];
                    } while (i > 2);
                }
                dstPts[dstOff] = xi;
                dstPts[dstOff + 1] = yi;
                dstOff += inc;
                srcOff += inc;
            }
        }
    }
}

