/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

public enum Capability {
    READ(166),
    WRITE(226),
    CREATE(40);

    private final short resourceKey;

    private Capability(short key) {
        this.resourceKey = key;
    }

    public static String[] providers(Locale locale, Vocabulary resources) {
        Collection<DataStoreProvider> providers = DataStores.providers();
        int count = providers.size();
        String[] list = new String[count * 2];
        int i = 0;
        for (DataStoreProvider provider : providers) {
            String complement;
            String title;
            StoreMetadata metadata = provider.getClass().getAnnotation(StoreMetadata.class);
            String capabilities = null;
            if (metadata != null) {
                for (Capability c : metadata.capabilities()) {
                    String e = resources.getString(c.resourceKey);
                    capabilities = capabilities == null ? e : resources.getString((short)181, capabilities, e.toLowerCase(locale));
                }
            }
            if (capabilities == null) {
                capabilities = resources.getString((short)207);
            }
            try {
                title = Capability.title(provider.getFormat().getFormatSpecificationCitation()).toString(locale);
                complement = provider.getShortName();
            }
            catch (BackingStoreException e) {
                title = provider.getShortName();
                complement = Exceptions.getLocalizedMessage(Exceptions.unwrap(e), locale);
            }
            if (complement != null && !complement.equals(title)) {
                title = resources.getString((short)158, title, complement);
            }
            list[i++] = capabilities;
            list[i++] = title;
        }
        return list;
    }

    private static InternationalString title(Citation specification) {
        InternationalString title = specification.getTitle();
        if (title != null) {
            return title;
        }
        for (InternationalString t : specification.getAlternateTitles()) {
            if (t == null) continue;
            return t;
        }
        return Vocabulary.formatInternational((short)210);
    }
}

