/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.sis.internal.storage.image.FormatFilter;
import org.apache.sis.internal.storage.image.WorldFileStoreProvider;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;

final class FormatFinder
implements AutoCloseable {
    final WorldFileStoreProvider provider;
    final StorageConnector connector;
    Object keepOpen;
    final Object storage;
    private ImageReader reader;
    private ImageWriter writer;
    private boolean readerLookupDone;
    private boolean writerLookupDone;
    final boolean isWritable;
    final boolean openAsWriter;
    final boolean fileIsEmpty;
    final String suffix;

    FormatFinder(WorldFileStoreProvider provider, StorageConnector connector) throws DataStoreException, IOException {
        this.provider = provider;
        this.connector = connector;
        Object storage = connector.getStorage();
        if (storage instanceof ImageReader) {
            this.reader = (ImageReader)storage;
            storage = this.reader.getInput();
            this.readerLookupDone = true;
        } else if (storage instanceof ImageWriter) {
            this.writer = (ImageWriter)storage;
            storage = this.writer.getOutput();
            this.writerLookupDone = true;
        }
        this.storage = storage;
        this.suffix = IOUtilities.extension(storage);
        if (this.writer != null) {
            this.isWritable = true;
            this.openAsWriter = true;
            this.fileIsEmpty = false;
        } else if (this.reader != null) {
            this.isWritable = this.reader.getInput() instanceof DataOutput;
            this.openAsWriter = false;
            this.fileIsEmpty = false;
        } else {
            Path path;
            this.isWritable = WorldFileStoreProvider.isWritable(connector);
            if (this.isWritable && (path = connector.getStorageAs(Path.class)) != null) {
                this.openAsWriter = this.fileIsEmpty = !Files.exists(path, new LinkOption[0]) || Files.size(path) == 0L;
                return;
            }
            this.openAsWriter = false;
            this.fileIsEmpty = false;
        }
    }

    final String[] getFormatName() throws DataStoreException, IOException {
        if (this.openAsWriter) {
            ImageWriterSpi spi;
            ImageWriter writer = this.getOrCreateWriter();
            if (writer != null && (spi = writer.getOriginatingProvider()) != null) {
                return spi.getFormatNames();
            }
        } else {
            ImageReaderSpi spi;
            ImageReader reader = this.getOrCreateReader();
            if (reader != null && (spi = reader.getOriginatingProvider()) != null) {
                return spi.getFormatNames();
            }
        }
        return null;
    }

    final ImageReader getOrCreateReader() throws DataStoreException, IOException {
        if (!this.readerLookupDone) {
            this.readerLookupDone = true;
            LinkedHashMap<ImageReaderSpi, Boolean> deferred = new LinkedHashMap<ImageReaderSpi, Boolean>();
            if (this.suffix != null) {
                this.reader = FormatFilter.SUFFIX.createReader(this.suffix, this, deferred);
            }
            if (this.reader == null) {
                this.reader = FormatFilter.SUFFIX.createReader(null, this, deferred);
                if (this.reader == null) {
                    ImageInputStream stream = null;
                    for (Map.Entry entry : deferred.entrySet()) {
                        ImageReaderSpi p;
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        if (stream == null) {
                            try {
                                if (this.isWritable) {
                                    stream = ImageIO.createImageOutputStream(this.storage);
                                }
                                if (stream == null && (stream = ImageIO.createImageInputStream(this.storage)) == null) {
                                    break;
                                }
                            }
                            catch (IIOException e) {
                                throw FormatFinder.unwrap(e);
                            }
                        }
                        if (!(p = (ImageReaderSpi)entry.getKey()).canDecodeInput(stream)) continue;
                        this.reader = p.createReaderInstance();
                        this.reader.setInput(stream);
                        this.keepOpen = this.storage;
                        break;
                    }
                }
            }
        }
        return this.reader;
    }

    final ImageWriter getOrCreateWriter() throws DataStoreException, IOException {
        if (!this.writerLookupDone) {
            this.writerLookupDone = true;
            LinkedHashMap<ImageWriterSpi, Boolean> deferred = new LinkedHashMap<ImageWriterSpi, Boolean>();
            if (this.suffix != null) {
                this.writer = FormatFilter.SUFFIX.createWriter(this.suffix, this, null, deferred);
            }
            if (this.writer == null) {
                this.writer = FormatFilter.SUFFIX.createWriter(null, this, null, deferred);
                if (this.writer == null) {
                    ImageOutputStream stream = null;
                    for (Map.Entry entry : deferred.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        if (stream == null) {
                            File file = this.connector.getStorageAs(File.class);
                            if (file != null) {
                                stream = new FileImageOutputStream(file);
                            } else {
                                try {
                                    stream = ImageIO.createImageOutputStream(this.storage);
                                    if (stream == null) {
                                        break;
                                    }
                                }
                                catch (IIOException e) {
                                    throw FormatFinder.unwrap(e);
                                }
                            }
                        }
                        ImageWriterSpi p = (ImageWriterSpi)entry.getKey();
                        this.writer = p.createWriterInstance();
                        this.writer.setOutput(stream);
                        this.keepOpen = this.storage;
                        break;
                    }
                }
            }
        }
        return this.writer;
    }

    private static IOException unwrap(IIOException e) {
        Throwable cause = e.getCause();
        return cause instanceof IOException ? (IOException)cause : e;
    }

    @Override
    public final void close() throws DataStoreException {
        this.connector.closeAllExcept(this.keepOpen);
    }
}

