/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.awt.image.RasterFormatException;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.NoSuchDataException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.PerformanceLevel;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class AbstractGridCoverageResource
extends AbstractResource
implements GridCoverageResource {
    protected AbstractGridCoverageResource(Resource parent) {
        super(parent);
    }

    protected AbstractGridCoverageResource(StoreListeners parentListeners, boolean hidden) {
        super(parentListeners, hidden);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        GridGeometry gg = this.getGridGeometry();
        if (gg != null && gg.isDefined(2)) {
            return Optional.of(gg.getEnvelope());
        }
        return Optional.empty();
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        return builder.build();
    }

    protected DataStoreException canNotRead(String filename, GridGeometry request, Throwable cause) {
        boolean DOMAIN = true;
        int REFERENCING = 2;
        int CONTENT = 3;
        int type = 0;
        Envelope bounds = null;
        if (cause instanceof DisjointExtentException) {
            type = 1;
            if (request != null && request.isDefined(2)) {
                bounds = request.getEnvelope();
            }
        } else if (cause instanceof RuntimeException) {
            Throwable c = cause.getCause();
            if (AbstractGridCoverageResource.isReferencing(c)) {
                type = 2;
                cause = c;
            } else if (cause instanceof ArithmeticException || cause instanceof RasterFormatException) {
                type = 3;
            }
        } else if (AbstractGridCoverageResource.isReferencing(cause)) {
            type = 2;
        }
        String message = this.createExceptionMessage(filename, bounds);
        switch (type) {
            case 1: {
                return new NoSuchDataException(message, cause);
            }
            case 2: {
                return new DataStoreReferencingException(message, cause);
            }
            case 3: {
                return new DataStoreContentException(message, cause);
            }
        }
        return new DataStoreException(message, cause);
    }

    private static boolean isReferencing(Throwable cause) {
        return cause instanceof FactoryException || cause instanceof TransformException;
    }

    protected void logReadOperation(Object file, GridGeometry domain, long startTime) {
        long nanos;
        Level level;
        Logger logger = this.listeners.getLogger();
        if (logger.isLoggable(level = PerformanceLevel.forDuration(nanos = System.nanoTime() - startTime, TimeUnit.NANOSECONDS))) {
            Locale locale = this.listeners.getLocale();
            Object[] parameters = new Object[6];
            parameters[0] = IOUtilities.filename(file != null ? file : this.listeners.getSourceName());
            parameters[5] = (double)nanos / 1.0E9;
            domain.getGeographicExtent().ifPresentOrElse(box -> {
                AngleFormat f = new AngleFormat(locale);
                double min = box.getSouthBoundLatitude();
                double max = box.getNorthBoundLatitude();
                f.setPrecision(max - min, true);
                f.setRoundingMode(RoundingMode.FLOOR);
                parameters[1] = f.format(new Latitude(min));
                f.setRoundingMode(RoundingMode.CEILING);
                parameters[2] = f.format(new Latitude(max));
                min = box.getWestBoundLongitude();
                max = box.getEastBoundLongitude();
                f.setPrecision(max - min, true);
                f.setRoundingMode(RoundingMode.FLOOR);
                parameters[3] = f.format(new Longitude(min));
                f.setRoundingMode(RoundingMode.CEILING);
                parameters[4] = f.format(new Longitude(max));
            }, () -> {
                block3: {
                    block2: {
                        if (!domain.isDefined(2)) break block2;
                        Envelope box = domain.getEnvelope();
                        int dimension = Math.min(box.getDimension(), 2);
                        int t = 1;
                        for (int i = 0; i < dimension; ++i) {
                            parameters[t++] = box.getMinimum(i);
                            parameters[t++] = box.getMaximum(i);
                        }
                        break block3;
                    }
                    if (!domain.isDefined(4)) break block3;
                    GridExtent box = domain.getExtent();
                    int dimension = Math.min(box.getDimension(), 2);
                    int t = 1;
                    for (int i = 0; i < dimension; ++i) {
                        parameters[t++] = box.getLow(i);
                        parameters[t++] = box.getHigh(i);
                    }
                }
            });
            LogRecord record = Resources.forLocale(locale).getLogRecord(level, (short)59, parameters);
            record.setSourceClassName(GridCoverageResource.class.getName());
            record.setSourceMethodName("read");
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
    }
}

