/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.CommonDomainFinder;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.DimensionSelector;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

final class GridSlice {
    static final PixelInCell CELL_ANCHOR = PixelInCell.CELL_CORNER;
    final GridCoverageResource resource;
    private final GridGeometry geometry;
    private final long[] offset;

    GridSlice(GridCoverageResource slice) throws DataStoreException {
        this.resource = slice;
        this.geometry = slice.getGridGeometry();
        this.offset = new long[this.geometry.getDimension()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GroupByTransform getList(List<GroupByCRS<GroupByTransform>> groups, MergeStrategy strategy) throws NoninvertibleTransformException {
        List transforms;
        MathTransform gridToCRS = this.geometry.getGridToCRS(CELL_ANCHOR);
        MathTransform crsToGrid = gridToCRS.inverse();
        List list = transforms = GroupByCRS.getOrAdd(groups, (GridGeometry)this.geometry).members;
        synchronized (list) {
            for (GroupByTransform c : transforms) {
                Matrix groupToSlice = c.linearTransform(crsToGrid);
                if (CommonDomainFinder.integerTranslation(groupToSlice, this.offset) == null) continue;
                c.strategy = strategy;
                return c;
            }
            GroupByTransform c = new GroupByTransform(this.geometry, gridToCRS, strategy);
            transforms.add(c);
            return c;
        }
    }

    final GridExtent getGridExtent() {
        return this.geometry.getExtent();
    }

    final void getGridExtent(int i, DimensionSelector[] writeTo) {
        GridExtent extent = this.getGridExtent();
        int dim = writeTo.length;
        while (--dim >= 0) {
            writeTo[dim].setSliceExtent(i, Math.subtractExact(extent.getMedian(dim), this.offset[dim]), extent.getSize(dim));
        }
    }

    final long getGridLow(int dim) {
        return Math.subtractExact(this.geometry.getExtent().getLow(dim), this.offset[dim]);
    }

    final long[] getOffset(Map<GridSlice, long[]> shared) {
        long[] old = shared.putIfAbsent(this, this.offset);
        return old != null ? old : this.offset;
    }

    public final boolean equals(Object other) {
        return other instanceof GridSlice && Arrays.equals(((GridSlice)other).offset, this.offset);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.offset);
    }

    public String toString() {
        String id = null;
        if (this.resource != null) {
            try {
                id = this.resource.getIdentifier().orElse(null);
            }
            catch (DataStoreException e) {
                id = e.toString();
            }
        }
        return Strings.toString(this.getClass(), null, id);
    }
}

