/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.LoggedFormat;

public final class TimeParser {
    static final long MILLIS_IN_DAY = 86400000L;
    private static final DatePattern[] PATTERNS = new DatePattern[]{new DatePattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", null), new DatePattern("yyyy-MM-dd'T'HH:mm:ss'Z'", null), new DatePattern("yyyy-MM-dd'T'HH:mm:ss", null), new DatePattern("yyyy-MM-dd'T'HH:mm'Z'", null), new DatePattern("yyyy-MM-dd'T'HH:mm", null), new DatePattern("yyyy-MM-dd'T'HH'Z'", "PT1H"), new DatePattern("yyyy-MM-dd'T'HH", "PT1H"), new DatePattern("yyyy-MM-dd", "P1D"), new DatePattern("yyyy-MM", "P1M"), new DatePattern("yyyy", "P1Y")};
    private static final Map<TimeParser, DateFormat> PARSERS = new HashMap<TimeParser, DateFormat>(16);
    private final int numDateFields;
    private final int numTimeFields;
    private final boolean hasTimeZone;
    private final String period;

    private TimeParser(String pattern, String period) {
        int length = pattern.length();
        int numDateFields = 1;
        int numTimeFields = 0;
        boolean hasTimeZone = false;
        block7: for (int i = 0; i < length; ++i) {
            switch (pattern.charAt(i)) {
                case '-': {
                    if (numTimeFields != 0) continue block7;
                    ++numDateFields;
                    continue block7;
                }
                case 'T': {
                    if (numTimeFields != 0) continue block7;
                    numTimeFields = 1;
                    continue block7;
                }
                case ':': {
                    if (numTimeFields == 0) continue block7;
                    ++numTimeFields;
                    continue block7;
                }
                case '.': {
                    if (numTimeFields < 3) continue block7;
                    ++numTimeFields;
                    continue block7;
                }
                case 'Z': {
                    if (numTimeFields == 0) continue block7;
                    hasTimeZone = true;
                    continue block7;
                }
            }
        }
        this.numDateFields = numDateFields;
        this.numTimeFields = numTimeFields;
        this.hasTimeZone = hasTimeZone;
        this.period = period;
    }

    public static void parse(String value, long defaultPeriod, List<Date> dates) throws ParseException {
        TimeParser.parse(value, defaultPeriod, dates, false);
    }

    public static void parse(String value, long defaultPeriod, List<Date> dates, boolean transformIncompleteDateInPeriod) throws ParseException {
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        StringTokenizer periods = new StringTokenizer(value, ",");
        while (periods.hasMoreTokens()) {
            boolean single;
            StringTokenizer elements = new StringTokenizer(periods.nextToken().trim(), "/");
            if (!elements.hasMoreTokens()) continue;
            String token = elements.nextToken();
            boolean bl = single = !elements.hasMoreTokens();
            if (single) {
                List<Date> period = TimeParser.parseDatePeriod(token, transformIncompleteDateInPeriod);
                dates.addAll(period);
                continue;
            }
            Date start = TimeParser.parseDate(token);
            Date end = TimeParser.parseDate(elements.nextToken());
            long period = elements.hasMoreTokens() ? TimeParser.parsePeriod(elements.nextToken()) : defaultPeriod;
            long endTime = end.getTime();
            if (period <= 0L) {
                dates.add(start);
                dates.add(end);
                continue;
            }
            for (long time = start.getTime(); time <= endTime; time += period) {
                dates.add(new Date(time));
            }
        }
    }

    private static List<Date> parseDatePeriod(String value, boolean transformIncompleteInPeriod) throws ParseException {
        value = value.trim();
        TimeParser tmp = new TimeParser(value, null);
        DateFormat format = null;
        String period = null;
        for (Map.Entry<TimeParser, DateFormat> candidate : PARSERS.entrySet()) {
            TimeParser key = candidate.getKey();
            if (key == null || !key.equals(tmp)) continue;
            tmp = key;
            format = candidate.getValue();
            period = tmp.period;
            break;
        }
        if (format == null) {
            format = PARSERS.get(null);
        }
        Date start = TimeParser.parseDate(value, format);
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(start);
        if (period != null && transformIncompleteInPeriod) {
            switch (period) {
                case "PT1H": {
                    Date end = new Date(start.getTime() + 3600000L - 1000L);
                    dates.add(end);
                    break;
                }
                case "P1D": {
                    Date end = new Date(start.getTime() + 86400000L - 1000L);
                    dates.add(end);
                    break;
                }
                case "P1M": {
                    Calendar c = Calendar.getInstance();
                    c.clear();
                    c.setTime(start);
                    c.set(2, c.get(2) + 1);
                    Date end = new Date(c.getTimeInMillis() - 1000L);
                    dates.add(end);
                    break;
                }
                case "P1Y": {
                    Calendar c = Calendar.getInstance();
                    c.clear();
                    c.setTime(start);
                    c.set(1, c.get(1) + 1);
                    Date end = new Date(c.getTimeInMillis() - 1000L);
                    dates.add(end);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown period:" + period));
                }
            }
        }
        return dates;
    }

    private static Date parseDate(String value) throws ParseException {
        DateFormat format = PARSERS.get(new TimeParser(value = value.trim(), null));
        if (format == null) {
            format = PARSERS.get(null);
        }
        return TimeParser.parseDate(value, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parseDate(String value, DateFormat format) throws ParseException {
        Date time;
        ParsePosition position = new ParsePosition(0);
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            time = format.parse(value, position);
        }
        int index = position.getIndex();
        int length = value.length();
        if (index != length) {
            int errorIndex = Math.max(index, position.getErrorIndex());
            throw new ParseException(LoggedFormat.formatUnparsable(value, index, errorIndex, null), errorIndex);
        }
        return time;
    }

    static long parsePeriod(String period) throws ParseException {
        int length = period.length();
        if (length != 0 && Character.toUpperCase(period.charAt(0)) != 'P') {
            throw new ParseException(Errors.format((short)197, period, period.substring(0, 1)), 0);
        }
        long millis = 0L;
        boolean time = false;
        int lower = 0;
        while (++lower < length) {
            double factor;
            double value;
            int upper;
            block19: {
                char letter;
                block18: {
                    letter = Character.toUpperCase(period.charAt(lower));
                    if (letter == 'T') {
                        time = true;
                        if (++lower >= length) break;
                    }
                    upper = lower;
                    letter = period.charAt(upper);
                    while (!Character.isLetter(letter) || letter == 'e' || letter == 'E') {
                        if (++upper >= length) {
                            throw new ParseException(Errors.format((short)173), lower);
                        }
                        letter = period.charAt(upper);
                    }
                    letter = Character.toUpperCase(letter);
                    String number = period.substring(lower, upper);
                    try {
                        value = Double.parseDouble(number);
                    }
                    catch (NumberFormatException exception) {
                        ParseException e = new ParseException(Errors.format((short)196, number), lower);
                        e.initCause(exception);
                        throw e;
                    }
                    if (!time) break block18;
                    switch (letter) {
                        case 'S': {
                            factor = 1000.0;
                            break block19;
                        }
                        case 'M': {
                            factor = 60000.0;
                            break block19;
                        }
                        case 'H': {
                            factor = 3600000.0;
                            break block19;
                        }
                        default: {
                            throw new ParseException("Unknown time symbol: " + letter, upper);
                        }
                    }
                }
                switch (letter) {
                    case 'D': {
                        factor = 8.64E7;
                        break;
                    }
                    case 'W': {
                        factor = 6.048E8;
                        break;
                    }
                    case 'M': {
                        factor = 2.592E9;
                        break;
                    }
                    case 'Y': {
                        factor = 3.15576E10;
                        break;
                    }
                    default: {
                        throw new ParseException("Unknown period symbol: " + letter, upper);
                    }
                }
            }
            millis += Math.round(value * factor);
            lower = upper;
        }
        return millis;
    }

    public static Date toDate(String strTime) throws ParseException {
        if (strTime == null) {
            return null;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        TimeParser.parse(strTime, 0L, dates);
        return !dates.isEmpty() ? (Date)dates.get(0) : null;
    }

    public boolean equals(Object other) {
        if (other instanceof TimeParser) {
            TimeParser that = (TimeParser)other;
            return this.numDateFields == that.numDateFields && this.numTimeFields == that.numTimeFields && this.hasTimeZone == that.hasTimeZone;
        }
        return false;
    }

    public int hashCode() {
        return this.numDateFields + 37 * this.numTimeFields + (this.hasTimeZone ? 1231 : 1237);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append('[').append(this.numDateFields).append(',').append(this.numTimeFields);
        DateFormat format = PARSERS.get(this);
        if (format instanceof SimpleDateFormat) {
            builder.append(",\"").append(((SimpleDateFormat)format).toPattern()).append('\"');
        }
        return builder.append(']').toString();
    }

    static {
        TimeZone timezone = TimeZone.getTimeZone("UTC");
        for (int i = 0; i < PATTERNS.length; ++i) {
            DatePattern dp = PATTERNS[i];
            SimpleDateFormat format = new SimpleDateFormat(dp.pattern, Locale.CANADA);
            format.setTimeZone(timezone);
            if (PARSERS.put(new TimeParser(dp.pattern, dp.period), format) != null) {
                throw new AssertionError((Object)dp.pattern);
            }
            if (i != 0) continue;
            PARSERS.put(null, format);
        }
    }

    private static class DatePattern {
        public final String pattern;
        public final String period;

        public DatePattern(String pattern, String period) {
            this.pattern = pattern;
            this.period = period;
        }
    }
}

