/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.io.ClassFormat;
import org.apache.sis.io.DefaultFormat;
import org.apache.sis.io.IdentifiedObjectFormat;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.QuantityFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;

public abstract class CompoundFormat<T>
extends Format
implements Localized {
    private static final long serialVersionUID = -689151528653024968L;
    private final Locale locale;
    private final TimeZone timezone;
    private transient Map<Class<?>, Format> formats;

    protected CompoundFormat(Locale locale, TimeZone timezone) {
        this.locale = locale != null ? locale : Locale.ROOT;
        this.timezone = timezone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public Locale getLocale(Locale.Category category) {
        ArgumentChecks.ensureNonNull("category", (Object)category);
        return this.getLocale();
    }

    public TimeZone getTimeZone() {
        return this.timezone != null ? (TimeZone)this.timezone.clone() : TimeZone.getTimeZone("UTC");
    }

    public abstract Class<? extends T> getValueType();

    public abstract T parse(CharSequence var1, ParsePosition var2) throws ParseException;

    public T parseObject(String text, ParsePosition pos) {
        try {
            return this.parse(text, pos);
        }
        catch (ParseException e) {
            if (pos.getErrorIndex() < 0) {
                pos.setErrorIndex(e.getErrorOffset());
            }
            return null;
        }
    }

    public T parseObject(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        T value = this.parse(text, pos);
        if (value != null) {
            int c;
            int length = text.length();
            int n = 0;
            int i = pos.getIndex();
            do {
                if ((i += n) >= length) {
                    return value;
                }
                c = text.codePointAt(i);
                n = Character.charCount(c);
            } while (Character.isSpaceChar(c) || Character.isISOControl(c));
            pos.setErrorIndex(i);
        }
        throw new LocalizedParseException(this.getLocale(Locale.Category.DISPLAY), this.getValueType(), text, pos);
    }

    public abstract void format(T var1, Appendable var2) throws IOException;

    @Override
    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition pos) {
        Class<T> valueType = this.getValueType();
        ArgumentChecks.ensureCanCast("object", valueType, object);
        try {
            this.format(valueType.cast(object), toAppendTo);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return toAppendTo;
    }

    protected Format getFormat(Class<?> valueType) {
        Format format;
        if (this.formats == null) {
            this.formats = new IdentityHashMap(4);
        }
        if ((format = this.formats.get(valueType)) == null && !this.formats.containsKey(valueType)) {
            format = this.createFormat(valueType);
            if (format == null) {
                Class<?>[] interfaces = Classes.getAllInterfaces(valueType);
                Class<?> type = null;
                int i = 0;
                while (true) {
                    if (i < interfaces.length) {
                        type = interfaces[i];
                    } else {
                        if (i == interfaces.length) {
                            type = valueType;
                        }
                        if ((type = type.getSuperclass()) == null) break;
                    }
                    format = this.formats.get(type);
                    if (format != null) break;
                    format = this.createFormat(type);
                    if (format != null) {
                        this.formats.put(type, format);
                        break;
                    }
                    ++i;
                }
            }
            this.formats.put(valueType, format);
        }
        return format;
    }

    protected Format createFormat(Class<?> valueType) {
        Locale locale = this.getLocale(Locale.Category.FORMAT);
        if (Number.class.isAssignableFrom(valueType)) {
            if (Locale.ROOT.equals(locale)) {
                return DefaultFormat.getInstance(valueType);
            }
            if (valueType == Number.class) {
                return NumberFormat.getInstance(locale);
            }
            if (Numbers.isInteger(valueType)) {
                return NumberFormat.getIntegerInstance(locale);
            }
        } else {
            if (valueType == Date.class) {
                DateFormat format = !Locale.ROOT.equals(locale) ? DateFormat.getDateTimeInstance(2, 2, locale) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
                format.setTimeZone(this.getTimeZone());
                return format;
            }
            if (valueType == Angle.class) {
                return AngleFormat.getInstance(locale);
            }
            if (valueType == Unit.class) {
                return new UnitFormat(locale);
            }
            if (valueType == Quantity.class) {
                return new QuantityFormat(locale);
            }
            if (valueType == Range.class) {
                return new RangeFormat(locale);
            }
            if (valueType == DirectPosition.class) {
                return MetadataServices.getInstance().createCoordinateFormat(locale, this.getTimeZone());
            }
            if (valueType == Class.class) {
                return ClassFormat.INSTANCE;
            }
            Object[] interfaces = valueType.getInterfaces();
            if (ArraysExt.contains(interfaces, IdentifiedObject.class)) {
                return new IdentifiedObjectFormat(locale);
            }
        }
        return null;
    }

    @Override
    public CompoundFormat<T> clone() {
        CompoundFormat clone = (CompoundFormat)super.clone();
        if (clone.formats != null) {
            clone.formats = new IdentityHashMap(clone.formats);
            for (Map.Entry<Class<?>, Format> entry : clone.formats.entrySet()) {
                entry.setValue((Format)entry.getValue().clone());
            }
        }
        return clone;
    }
}

