/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.apache.sis.internal.util.Acyclic;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.PropertyFormat;
import org.apache.sis.internal.util.TreeFormatCustomization;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public class TreeTableFormat
extends TabularFormat<TreeTable> {
    private static final long serialVersionUID = 147992015470098561L;
    static final TreeTableFormat INSTANCE = new TreeTableFormat(null, null);
    private Map<TableColumn<?>, Integer> columnIndices;
    private int indentation = 4;
    private int verticalLinePosition = 2;
    private transient String treeBlank;
    private transient String treeLine;
    private transient String treeCross;
    private transient String treeEnd;
    private Predicate<TreeTable.Node> nodeFilter;
    private transient Set<TreeTable.Node> recursivityGuard;
    private transient DecimalFormat adaptableFormat;
    private transient String defaultPattern;
    private transient boolean usingScientificNotation;

    public TreeTableFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.beforeFill = "\u2026\u2026";
        this.fillCharacter = (char)8230;
        this.omitTrailingNulls = true;
    }

    private void clearTreeSymbols() {
        this.treeBlank = null;
        this.treeLine = null;
        this.treeCross = null;
        this.treeEnd = null;
    }

    @Override
    public final Class<TreeTable> getValueType() {
        return TreeTable.class;
    }

    public TableColumn<?>[] getColumns() {
        return this.columnIndices != null ? DefaultTreeTable.getColumns(this.columnIndices) : null;
    }

    public void setColumns(TableColumn<?> ... columns) throws IllegalArgumentException {
        if (columns == null) {
            this.columnIndices = null;
        } else {
            ArgumentChecks.ensureNonEmpty("columns", columns);
            this.columnIndices = DefaultTreeTable.createColumnIndices(columns);
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("indentation", indentation);
        this.indentation = indentation;
        if (this.verticalLinePosition > indentation) {
            this.verticalLinePosition = indentation;
        }
        this.clearTreeSymbols();
    }

    public int getVerticalLinePosition() {
        return this.verticalLinePosition;
    }

    public void setVerticalLinePosition(int verticalLinePosition) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("verticalLinePosition", 0, this.indentation, verticalLinePosition);
        this.verticalLinePosition = verticalLinePosition;
        this.clearTreeSymbols();
    }

    public Predicate<TreeTable.Node> getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(Predicate<TreeTable.Node> filter) {
        this.nodeFilter = filter;
    }

    private Locale getDisplayLocale() {
        return this.getLocale(Locale.Category.DISPLAY);
    }

    final Format[] getFormats(TableColumn<?>[] columns, boolean mandatory) throws IllegalStateException {
        Format[] formats = new Format[columns.length];
        for (int i = 0; i < formats.length; ++i) {
            Class<String> valueType = columns[i].getElementType();
            formats[i] = this.getFormat(valueType);
            if (formats[i] != null || !mandatory || valueType.isAssignableFrom(String.class)) continue;
            throw new IllegalStateException(Errors.format((short)158, valueType));
        }
        return formats;
    }

    @Override
    public TreeTable parse(CharSequence text, ParsePosition pos) throws ParseException {
        int startNextLine;
        Matcher matcher = this.getColumnSeparatorMatcher(text);
        int length = text.length();
        int indexOfLineStart = pos.getIndex();
        int indentationLevel = 0;
        int[] indentations = new int[16];
        TreeTable.Node lastNode = null;
        DefaultTreeTable.Node root = null;
        DefaultTreeTable table = new DefaultTreeTable(this.columnIndices != null ? this.columnIndices : TableColumn.NAME_MAP);
        TableColumn<?>[] columns = DefaultTreeTable.getColumns(table.columnIndices);
        Format[] formats = this.getFormats(columns, true);
        do {
            int i;
            int c;
            char c2;
            int endOfLine;
            for (endOfLine = startNextLine = CharSequences.indexOfLineStart(text, 1, indexOfLineStart); endOfLine > indexOfLineStart && ((c2 = text.charAt(endOfLine - 1)) == '\r' || c2 == '\n'); --endOfLine) {
            }
            boolean hasChar = false;
            for (i = indexOfLineStart; i < endOfLine; i += Character.charCount(c)) {
                c = Character.codePointAt(text, i);
                if (Character.isSpaceChar(c)) continue;
                hasChar = true;
                if ("\u2500\u2502\u2514\u251c".indexOf(c) < 0) break;
            }
            if (!hasChar) break;
            int indexOfValue = i;
            i = CharSequences.skipTrailingWhitespaces(text, indexOfLineStart, i) - indexOfLineStart;
            DefaultTreeTable.Node node = new DefaultTreeTable.Node(table);
            matcher.region(indexOfValue, endOfLine);
            for (int ci = 0; ci < columns.length; ++ci) {
                boolean found = matcher.find();
                int endOfColumn = found ? matcher.start() : endOfLine;
                int endOfValue = CharSequences.skipTrailingWhitespaces(text, indexOfValue = CharSequences.skipLeadingWhitespaces(text, indexOfValue, endOfColumn), endOfColumn);
                if (endOfValue > indexOfValue) {
                    String valueText = text.subSequence(indexOfValue, endOfValue).toString();
                    try {
                        this.parseValue(node, columns[ci], formats[ci], valueText);
                    }
                    catch (ClassCastException | ParseException e) {
                        pos.setErrorIndex(indexOfValue);
                        if (e instanceof ParseException) {
                            indexOfValue += ((ParseException)e).getErrorOffset();
                        }
                        throw new LocalizedParseException(this.getDisplayLocale(), 154, new Object[]{columns[ci].getElementType(), valueText}, indexOfValue).initCause(e);
                    }
                }
                if (!found) break;
                indexOfValue = matcher.end();
            }
            if (root == null) {
                indentations[0] = i;
                root = node;
            } else {
                int p;
                while (i < (p = indentations[indentationLevel])) {
                    if (--indentationLevel < 0) {
                        pos.setErrorIndex(indexOfLineStart);
                        throw new LocalizedParseException(this.getDisplayLocale(), 98, new Object[]{node}, indexOfLineStart);
                    }
                    lastNode = lastNode.getParent();
                }
                if (i == p) {
                    TreeTable.Node parent = lastNode.getParent();
                    if (parent == null) {
                        pos.setErrorIndex(indexOfLineStart);
                        throw new LocalizedParseException(this.getDisplayLocale(), 98, new Object[]{node}, indexOfLineStart);
                    }
                    parent.getChildren().add(node);
                } else if (i > p) {
                    lastNode.getChildren().add(node);
                    if (++indentationLevel == indentations.length) {
                        indentations = Arrays.copyOf(indentations, indentationLevel * 2);
                    }
                    indentations[indentationLevel] = i;
                }
            }
            lastNode = node;
        } while ((indexOfLineStart = startNextLine) != length);
        if (root == null) {
            return null;
        }
        pos.setIndex(indexOfLineStart);
        table.setRoot(root);
        return table;
    }

    private <V> void parseValue(TreeTable.Node node, TableColumn<V> column, Format format, String text) throws ParseException {
        Object value = format != null ? format.parseObject(text) : text;
        node.setValue(column, column.getElementType().cast(value));
    }

    private void createTreeSymbols() {
        int indentation = this.indentation;
        int verticalLinePosition = this.verticalLinePosition;
        char[] buffer = new char[indentation];
        block6: for (int k = 0; k < 4; ++k) {
            char hc;
            int vc;
            if ((k & 2) == 0) {
                vc = (k & 1) == 0 ? 160 : 9474;
                hc = '\u00a0';
            } else {
                vc = (k & 1) == 0 ? 9492 : 9500;
                hc = '\u2500';
            }
            Arrays.fill(buffer, 0, verticalLinePosition, '\u00a0');
            buffer[verticalLinePosition] = vc;
            Arrays.fill(buffer, verticalLinePosition + 1, indentation, hc);
            String symbols = String.valueOf(buffer);
            switch (k) {
                case 0: {
                    this.treeBlank = symbols;
                    continue block6;
                }
                case 1: {
                    this.treeLine = symbols;
                    continue block6;
                }
                case 2: {
                    this.treeEnd = symbols;
                    continue block6;
                }
                case 3: {
                    this.treeCross = symbols;
                    continue block6;
                }
                default: {
                    throw new AssertionError(k);
                }
            }
        }
    }

    final String getTreeSymbols(boolean isParent, boolean isLast) {
        return isParent ? (isLast ? this.treeBlank : this.treeLine) : (isLast ? this.treeEnd : this.treeCross);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(TreeTable tree, Appendable toAppendTo) throws IOException {
        ArgumentChecks.ensureNonNull("tree", tree);
        if (this.treeBlank == null) {
            this.createTreeSymbols();
        }
        TableColumn<Object>[] columns = this.columnIndices != null ? DefaultTreeTable.getColumns(this.columnIndices) : (TableColumn[])tree.getColumns().toArray(TableColumn[]::new);
        if (this.recursivityGuard == null) {
            this.recursivityGuard = new HashSet<TreeTable.Node>();
        }
        try {
            Writer out = new Writer(toAppendTo, tree, columns, this.recursivityGuard);
            out.format(tree.getRoot(), 0);
            out.flush();
        }
        finally {
            this.recursivityGuard.clear();
        }
    }

    @Override
    protected Format createFormat(Class<?> valueType) {
        Format format = super.createFormat(valueType);
        if (format instanceof UnitFormat) {
            ((UnitFormat)format).setStyle(UnitFormat.Style.NAME);
        }
        return format;
    }

    protected void writeColumnSeparator(int nextColumn, TableAppender out) {
        out.append(this.beforeFill);
        out.nextColumn(this.fillCharacter);
        out.append(this.columnSeparator);
    }

    @Override
    public TreeTableFormat clone() {
        TreeTableFormat c = (TreeTableFormat)super.clone();
        c.recursivityGuard = null;
        return c;
    }

    private final class Writer
    extends PropertyFormat {
        private final Predicate<TreeTable.Node> filter;
        private final TableColumn<?>[] columns;
        private final Format[] formats;
        private final Object[] values;
        private boolean[] isLast;
        private final boolean multiLineCells;
        private final Set<TreeTable.Node> recursivityGuard;

        Writer(Appendable out, TreeTable tree, TableColumn<?>[] columns, Set<TreeTable.Node> recursivityGuard) {
            TreeFormatCustomization custom;
            Predicate<TreeTable.Node> more;
            super(columns.length >= 2 ? new TableAppender(out, "") : out);
            this.multiLineCells = this.out == out;
            this.columns = columns;
            this.formats = TreeTableFormat.this.getFormats(columns, false);
            this.values = new Object[columns.length];
            this.isLast = new boolean[8];
            this.recursivityGuard = recursivityGuard;
            Predicate<TreeTable.Node> filter = TreeTableFormat.this.nodeFilter;
            if (tree instanceof TreeFormatCustomization && (more = (custom = (TreeFormatCustomization)((Object)tree)).filter()) != null) {
                filter = filter != null ? more.and(filter) : more;
            }
            this.filter = filter;
            this.setTabulationExpanded(true);
            this.setLineSeparator(this.multiLineCells ? TreeTableFormat.this.getLineSeparator() : " \u00b6 ");
        }

        @Override
        public Locale getLocale() {
            return TreeTableFormat.this.getLocale();
        }

        @Override
        protected final String toString(Object value) {
            String text;
            Format format = TreeTableFormat.this.getFormat(value.getClass());
            if (format instanceof DecimalFormat && Numbers.isFloat(value.getClass())) {
                double number = ((Number)value).doubleValue();
                if (number != (double)((int)number)) {
                    int nf;
                    boolean preferScientificNotation;
                    if (TreeTableFormat.this.adaptableFormat == null) {
                        TreeTableFormat.this.adaptableFormat = (DecimalFormat)format.clone();
                        TreeTableFormat.this.defaultPattern = TreeTableFormat.this.adaptableFormat.toPattern();
                    }
                    boolean bl = preferScientificNotation = (nf = DecimalFunctions.fractionDigitsForValue(number)) > 20 || nf < 7;
                    if (preferScientificNotation != TreeTableFormat.this.usingScientificNotation) {
                        TreeTableFormat.this.usingScientificNotation = preferScientificNotation;
                        TreeTableFormat.this.adaptableFormat.applyPattern(preferScientificNotation ? "0.0############E0" : TreeTableFormat.this.defaultPattern);
                    }
                    if (!preferScientificNotation) {
                        TreeTableFormat.this.adaptableFormat.setMaximumFractionDigits(nf - 2);
                    }
                    text = TreeTableFormat.this.adaptableFormat.format(value);
                } else {
                    text = format.format(value);
                }
            } else {
                text = format != null ? format.format(value) : value.toString();
            }
            return text;
        }

        final void format(TreeTable.Node node, int level) throws IOException {
            boolean omitCheck;
            int n;
            int i;
            for (i = 0; i < level; ++i) {
                this.out.append(TreeTableFormat.this.getTreeSymbols(i != level - 1, this.isLast[i]));
            }
            for (i = 0; i < this.columns.length; ++i) {
                this.values[i] = node.getValue(this.columns[i]);
            }
            if (TreeTableFormat.this.omitTrailingNulls) {
                for (n = this.values.length - 1; n > 0 && this.values[n] == null; --n) {
                }
            }
            for (int i2 = 0; i2 <= n; ++i2) {
                if (i2 != 0) {
                    TreeTableFormat.this.writeColumnSeparator(i2, (TableAppender)this.out);
                }
                this.columnFormat = this.formats[i2];
                this.appendValue(this.values[i2]);
                this.clear();
            }
            this.out.append(TreeTableFormat.this.lineSeparator);
            if (level >= this.isLast.length) {
                this.isLast = Arrays.copyOf(this.isLast, level * 2);
            }
            if ((omitCheck = node.getClass().isAnnotationPresent(Acyclic.class)) || this.recursivityGuard.add(node)) {
                boolean needLineSeparator = this.multiLineCells;
                String lineSeparator = needLineSeparator ? this.getLineSeparator() : null;
                Iterator<TreeTable.Node> it = node.getChildren().iterator();
                TreeTable.Node next = this.next(it);
                while (next != null) {
                    TreeTable.Node child = next;
                    next = this.next(it);
                    this.isLast[level] = next == null;
                    if ((needLineSeparator |= this.isLast[level]) && lineSeparator != null) {
                        this.setLineSeparator(lineSeparator + TreeTableFormat.this.getTreeSymbols(true, this.isLast[level]));
                    }
                    this.format(child, level + 1);
                }
                if (lineSeparator != null) {
                    this.setLineSeparator(lineSeparator);
                }
                if (!omitCheck && !this.recursivityGuard.remove(node)) {
                    throw new ConcurrentModificationException();
                }
            } else {
                for (int i3 = 0; i3 < level; ++i3) {
                    this.out.append(TreeTableFormat.this.getTreeSymbols(true, this.isLast[i3]));
                }
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                this.out.append(TreeTableFormat.this.treeBlank).append('(').append(Vocabulary.getResources(locale).getString((short)46).toLowerCase(locale)).append(')').append(TreeTableFormat.this.lineSeparator);
            }
        }

        private TreeTable.Node next(Iterator<? extends TreeTable.Node> it) {
            while (it.hasNext()) {
                TreeTable.Node next = it.next();
                if (next == null || this.filter != null && !this.filter.test(next)) continue;
                return next;
            }
            return null;
        }
    }
}

