/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import org.geotoolkit.geometry.jts.awt.JTSEmptyIterator;
import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.geotoolkit.geometry.jts.awt.JTSLineIterator;
import org.geotoolkit.geometry.jts.awt.JTSPointIterator;
import org.geotoolkit.geometry.jts.awt.JTSPolygonIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.MathTransform;

public class JTSGeomCollectionIterator
extends JTSGeometryIterator<GeometryCollection> {
    protected int nbGeom = 1;
    protected int currentGeom;
    protected JTSGeometryIterator currentIterator;
    protected boolean done = false;

    public JTSGeomCollectionIterator(GeometryCollection gc, MathTransform trs) {
        super(gc, trs);
        this.reset();
    }

    @Override
    public void reset() {
        this.currentGeom = 0;
        this.done = false;
        this.nbGeom = ((GeometryCollection)this.geometry).getNumGeometries();
        if (this.geometry != null && this.nbGeom > 0) {
            this.prepareIterator(((GeometryCollection)this.geometry).getGeometryN(0));
        } else {
            this.done = true;
        }
    }

    @Override
    public void setGeometry(GeometryCollection geom) {
        super.setGeometry(geom);
        this.nbGeom = geom == null ? 0 : geom.getNumGeometries();
    }

    protected void prepareIterator(Geometry candidate) {
        if (candidate.isEmpty()) {
            if (!(this.currentIterator instanceof JTSEmptyIterator)) {
                this.currentIterator = JTSEmptyIterator.INSTANCE;
            }
        } else if (candidate instanceof Point) {
            if (this.currentIterator instanceof JTSPointIterator) {
                this.currentIterator.setGeometry(candidate);
            } else {
                this.currentIterator = new JTSPointIterator((Point)candidate, this.transform);
            }
        } else if (candidate instanceof Polygon) {
            if (this.currentIterator instanceof JTSPolygonIterator) {
                this.currentIterator.setGeometry(candidate);
            } else {
                this.currentIterator = new JTSPolygonIterator((Polygon)candidate, this.transform);
            }
        } else if (candidate instanceof LineString) {
            if (this.currentIterator instanceof JTSLineIterator) {
                this.currentIterator.setGeometry(candidate);
            } else {
                this.currentIterator = new JTSLineIterator((LineString)candidate, this.transform);
            }
        } else if (candidate instanceof GeometryCollection) {
            if (this.currentIterator instanceof JTSGeomCollectionIterator) {
                this.currentIterator.setGeometry(candidate);
            } else {
                this.currentIterator = new JTSGeomCollectionIterator((GeometryCollection)candidate, this.transform);
            }
        } else {
            this.currentIterator = JTSEmptyIterator.INSTANCE;
        }
    }

    @Override
    public void setTransform(MathTransform trs) {
        if (this.currentIterator != null) {
            this.currentIterator.setTransform(trs);
        }
        super.setTransform(trs);
    }

    @Override
    public int currentSegment(double[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    @Override
    public int currentSegment(float[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        this.currentIterator.next();
        if (this.currentIterator.isDone()) {
            if (this.currentGeom < this.nbGeom - 1) {
                ++this.currentGeom;
                this.prepareIterator(((GeometryCollection)this.geometry).getGeometryN(this.currentGeom));
            } else {
                this.done = true;
            }
        }
    }
}

