/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.referencing.operation.MathTransform;

public final class JTSMultiLineIterator
extends JTSGeometryIterator<MultiLineString> {
    private int coordinateCount;
    private int nbGeom = 0;
    private int currentGeom = -1;
    private boolean done = false;
    private CoordinateSequence currentSequence = null;
    private int currentCoord = -1;

    public JTSMultiLineIterator(MultiLineString ls, MathTransform trs) {
        super(ls, trs);
        this.setGeometry(ls);
    }

    @Override
    public void setGeometry(MultiLineString geom) {
        super.setGeometry(geom);
        if (geom != null) {
            this.nbGeom = geom.getNumGeometries();
            this.nextSubGeom();
        }
        this.reset();
    }

    private void nextSubGeom() {
        if (++this.currentGeom >= this.nbGeom) {
            this.currentSequence = null;
            this.currentCoord = -1;
            this.done = true;
        } else {
            LineString subGeom = (LineString)((MultiLineString)this.geometry).getGeometryN(this.currentGeom);
            this.currentSequence = subGeom.getCoordinateSequence();
            this.coordinateCount = this.currentSequence.size();
            if (this.coordinateCount == 0) {
                this.nextSubGeom();
            } else {
                this.currentCoord = 0;
                this.done = false;
            }
        }
    }

    @Override
    public void reset() {
        this.currentGeom = -1;
        this.nextSubGeom();
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (++this.currentCoord >= this.coordinateCount) {
            this.nextSubGeom();
        }
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = this.currentSequence.getX(this.currentCoord);
            coords[1] = this.currentSequence.getY(this.currentCoord);
            this.safeTransform(coords, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentCoord == this.coordinateCount) {
            return 4;
        }
        coords[0] = this.currentSequence.getX(this.currentCoord);
        coords[1] = this.currentSequence.getY(this.currentCoord);
        this.safeTransform(coords, 0, coords, 0, 1);
        return 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = (float)this.currentSequence.getX(this.currentCoord);
            coords[1] = (float)this.currentSequence.getY(this.currentCoord);
            this.safeTransform(coords, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentCoord == this.coordinateCount) {
            return 4;
        }
        coords[0] = (float)this.currentSequence.getX(this.currentCoord);
        coords[1] = (float)this.currentSequence.getY(this.currentCoord);
        this.safeTransform(coords, 0, coords, 0, 1);
        return 1;
    }
}

