/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.coordinatesequence;

import org.geotoolkit.geometry.jts.coordinatesequence.CSBuilder;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

public abstract class PackedCSBuilder
implements CSBuilder {
    int size = -1;
    int dimensions = -1;

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDimension() {
        return this.dimensions;
    }

    public static class Float
    extends PackedCSBuilder {
        float[] coordinates;
        PackedCoordinateSequenceFactory factory = new PackedCoordinateSequenceFactory(1);

        @Override
        public void start(int size, int dimensions) {
            this.coordinates = new float[size * dimensions];
            this.size = size;
            this.dimensions = dimensions;
        }

        @Override
        public CoordinateSequence end() {
            CoordinateSequence cs = this.factory.create(this.coordinates, this.dimensions);
            this.coordinates = null;
            this.size = -1;
            this.dimensions = -1;
            return cs;
        }

        @Override
        public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
            this.coordinates[coordinateIndex * this.dimensions + ordinateIndex] = (float)value;
        }

        @Override
        public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
            PackedCoordinateSequence pcs = (PackedCoordinateSequence)sequence;
            pcs.setOrdinate(coordinateIndex, ordinateIndex, value);
        }

        @Override
        public double getOrdinate(int ordinateIndex, int coordinateIndex) {
            return this.coordinates[coordinateIndex * this.dimensions + ordinateIndex];
        }
    }

    public static class Double
    extends PackedCSBuilder {
        double[] coordinates;
        PackedCoordinateSequenceFactory factory = new PackedCoordinateSequenceFactory(0);

        @Override
        public void start(int size, int dimensions) {
            this.coordinates = new double[size * dimensions];
            this.size = size;
            this.dimensions = dimensions;
        }

        @Override
        public CoordinateSequence end() {
            CoordinateSequence cs = this.factory.create(this.coordinates, this.dimensions);
            this.coordinates = null;
            this.size = -1;
            this.dimensions = -1;
            return cs;
        }

        @Override
        public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
            this.coordinates[coordinateIndex * this.dimensions + ordinateIndex] = value;
        }

        @Override
        public double getOrdinate(int ordinateIndex, int coordinateIndex) {
            return this.coordinates[coordinateIndex * this.dimensions + ordinateIndex];
        }

        @Override
        public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
            PackedCoordinateSequence pcs = (PackedCoordinateSequence)sequence;
            pcs.setOrdinate(coordinateIndex, ordinateIndex, value);
        }
    }
}

