/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class Assertions
extends Static {
    private static final double INVERSE_TOLERANCE = 1.0E-7;
    private static final double FORWARD_TOLERANCE = 1.0E-7;
    private static final double DERIVATIVE_TOLERANCE = 0.1;

    private Assertions() {
    }

    private static boolean checkTransform(double[] expected, int offset, double x, double y, double tolerance) throws ProjectionException {
        if (expected != null) {
            Assertions.compare("x", expected[offset], x, tolerance);
            Assertions.compare("y", expected[offset + 1], y, tolerance);
        }
        return tolerance < Double.POSITIVE_INFINITY;
    }

    static boolean checkTransform(double[] expected, int offset, double x, double y) throws ProjectionException {
        return Assertions.checkTransform(expected, offset, x, y, 1.0E-7);
    }

    private static boolean checkInverseTransform(double[] expected, int offset, double \u03bb, double \u03c6, double tolerance) throws ProjectionException {
        Assertions.compare("latitude", expected[offset + 1], \u03c6, tolerance);
        if (Math.abs(1.5707963267948966 - Math.abs(\u03c6)) > 1.0E-6) {
            Assertions.compare("longitude", expected[offset], \u03bb, tolerance);
        }
        return tolerance < Double.POSITIVE_INFINITY;
    }

    static boolean checkInverseTransform(double[] expected, int offset, double \u03bb, double \u03c6) throws ProjectionException {
        return Assertions.checkInverseTransform(expected, offset, \u03bb, \u03c6, 1.0E-7);
    }

    static boolean checkDerivative(Matrix spherical, Matrix ellipsoidal) throws ProjectionException {
        if (spherical != null || ellipsoidal != null) {
            Assertions.compare("m00", spherical.getElement(0, 0), ellipsoidal.getElement(0, 0), 0.1);
            Assertions.compare("m01", spherical.getElement(0, 1), ellipsoidal.getElement(0, 1), 0.1);
            Assertions.compare("m10", spherical.getElement(1, 0), ellipsoidal.getElement(1, 0), 0.1);
            Assertions.compare("m11", spherical.getElement(1, 1), ellipsoidal.getElement(1, 1), 0.1);
        }
        return true;
    }

    private static void compare(String variable, double expected, double actual, double tolerance) throws ProjectionException {
        double delta = Math.abs(expected - actual);
        if (delta > tolerance) {
            if (variable.charAt(0) == 'l') {
                actual = Math.toDegrees(actual);
                expected = Math.toDegrees(expected);
            } else if (Math.abs(actual) > 30.0 && Math.abs(expected) > 30.0 && Math.signum(actual) == Math.signum(expected)) {
                return;
            }
            throw new ProjectionException(Errors.format((short)159, variable, String.valueOf(expected), String.valueOf(actual)) + "(\u0394" + variable + "=" + delta + " \u03b5=" + tolerance + ")");
        }
    }
}

