/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.List;
import java.util.Objects;
import org.apache.sis.util.Version;
import org.geotoolkit.lang.Static;

public final class Utilities
extends Static {
    private static final int PRIME_NUMBER = 31;
    public static final Version VERSION = new Version("5.0-SNAPSHOT");

    private Utilities() {
    }

    public static boolean equals(float o1, float o2) {
        return Float.floatToIntBits(o1) == Float.floatToIntBits(o2);
    }

    public static boolean equals(double o1, double o2) {
        return Double.doubleToLongBits(o1) == Double.doubleToLongBits(o2);
    }

    public static int hash(boolean value, int seed) {
        return seed * 31 + (value ? 1231 : 1237);
    }

    public static int hash(char value, int seed) {
        return seed * 31 + value;
    }

    public static int hash(int value, int seed) {
        return seed * 31 + value;
    }

    public static int hash(long value, int seed) {
        return seed * 31 + ((int)value ^ (int)(value >>> 32));
    }

    public static int hash(float value, int seed) {
        return seed * 31 + Float.floatToIntBits(value);
    }

    public static int hash(double value, int seed) {
        return Utilities.hash(Double.doubleToLongBits(value), seed);
    }

    public static int hash(Object value, int seed) throws AssertionError {
        seed *= 31;
        if (value != null) {
            assert (!value.getClass().isArray()) : Utilities.name(value);
            seed += value.hashCode();
        }
        return seed;
    }

    private static String name(Object object) {
        return object.getClass().getSimpleName();
    }

    public static boolean listNullEquals(List<?> l1, List<?> l2) {
        if (l1 == null && l2 != null && l2.isEmpty()) {
            return true;
        }
        if (l2 == null && l1 != null && l1.isEmpty()) {
            return true;
        }
        return Objects.equals(l1, l2);
    }
}

