/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.conformance;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.MalformedURLException;
import java.net.URI;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapiedr10.util.Link;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ApiDefinition
extends CommonFixture {
    private String response;
    private Link apiUrl = null;

    @BeforeClass(dependsOnMethods={"initCommonFixture"})
    public void retrieveApiUrl() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET);
        JsonPath jsonPath = request.jsonPath();
        this.apiUrl = OpenApiUtils.parseApiUrl(jsonPath);
    }

    @Test(description="Implements Abstract Test 4 (/conf/core/api-definition)", groups={"apidefinition"}, dependsOnGroups={"landingpage"})
    public void openapiDocumentRetrieval() {
        if (this.apiUrl == null || this.apiUrl.getHref().isEmpty()) {
            throw new AssertionError((Object)"Path to the API Definition could not be constructed from the landing page");
        }
        Response request = (Response)this.init().baseUri(this.apiUrl.getHref()).accept(this.apiUrl.getType()).when().request(Method.GET);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.asString();
    }

    @Test(description="Implements Abstract Test 5 (/conf/core/api-definition-success)", groups={"apidefinition"}, dependsOnMethods={"openapiDocumentRetrieval"})
    public void apiDefinitionValidation(ITestContext testContext) throws MalformedURLException {
        OpenApi3 apiModel = (OpenApi3)testContext.getSuite().getAttribute(SuiteAttribute.API_MODEL.getName());
        if (apiModel == null) {
            URI apiDefinitionLocation = (URI)testContext.getSuite().getAttribute(SuiteAttribute.API_DEFINITION.getName());
            throw new AssertionError((Object)("Could not create API model from URI: " + apiDefinitionLocation));
        }
        if (apiModel.isValid() && !this.apiUrl.getType().equals("application/vnd.oai.openapi+json;version=3.0")) {
            throw new SkipException("The API Definition was found to be valid. However, the Media Type identified by the Link to the API Definition document was not application/vnd.oai.openapi+json;version=3.0");
        }
        EtsAssert.assertTrue(apiModel.isValid(), this.createValidationMsg(apiModel));
    }

    private String createValidationMsg(OpenApi3 model) {
        StringBuilder sb = new StringBuilder();
        sb.append("API definition is not valid. Found following validation items:");
        if (!model.isValid()) {
            for (ValidationResults.ValidationItem item : model.getValidationItems()) {
                sb.append("  @ ").append(item.getPositionInfo()).append("  - ").append(item.getSeverity()).append(": ").append(item.getMsg());
            }
        }
        return sb.toString();
    }
}

