/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.corecollections;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.referencing.CRS;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CollectionsResponse
extends CommonFixture {
    protected URI iut;

    @DataProvider(name="collectionIDs")
    public Iterator<Object[]> collectionIDs(ITestContext testContext) {
        this.iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        Set<String> collectionTypes = this.extractCollectionIDs(this.iut);
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        collectionsData.add(new Object[]{collectionTypes});
        return collectionsData.iterator();
    }

    private Set<String> extractCollectionIDs(URI rootUri) {
        Response request = this.getCollectionResponse(null);
        ((ValidatableResponse)request.then()).statusCode(200);
        JsonPath response = request.jsonPath();
        List collections = response.getList("collections");
        HashSet<String> collectionTypes = new HashSet<String>();
        for (Object collection : collections) {
            Map collectionMap = (Map)collection;
            Object collectionType = collectionMap.get("id");
            collectionTypes.add((String)collectionType);
        }
        return collectionTypes;
    }

    @Test(description="Implements Abstract Test 9 (/conf/collections/rc-md-op) and Abstract Test 10 (/conf/rc-md-success)", dataProvider="collectionIDs", alwaysRun=true)
    public void validateRetrievalOfCollections(Object collectionIdentifiers) {
        Set collectionTypes = (Set)collectionIdentifiers;
        EtsAssert.assertTrue(collectionTypes.size() > 0, "Was not able to validate that information about the Collections was retrieved correctly");
    }

    @Test(description="Implements Abstract Test 11 (/conf/collections/src-md-op) and Abstract Test 12 (/conf/collections/src-md-success)", dataProvider="collectionIDs", alwaysRun=true)
    public void validateRetrievalOfEnvironmentalDataCollections(Object collectionIdentifiers) {
        Set collectionTypes = (Set)collectionIdentifiers;
        boolean identicalID = false;
        int i = 0;
        for (String collection : collectionTypes) {
            if (i == 0) {
                System.out.println(collection);
                Response request = this.getCollectionResponse(collection);
                ((ValidatableResponse)request.then()).statusCode(200);
                JsonPath response = request.jsonPath();
                if (response.getString("id").equals(collection)) {
                    identicalID = true;
                }
            }
            ++i;
        }
        EtsAssert.assertTrue(identicalID, "The id of the collection returned by the response did not match the collectionID in the URL");
    }

    @Test(description="Implements Abstract Test 8 (/conf/core/crs84)")
    public void collectionsCRS84() {
        boolean compliesWithCRS84Requirement = true;
        StringBuffer resultMessage = new StringBuffer();
        Response response = this.getCollectionResponse(null);
        JsonPath jsonPath = response.jsonPath();
        List collectionsList = jsonPath.getList("collections");
        for (int t = 0; t < collectionsList.size(); ++t) {
            boolean supportsCRS84 = false;
            HashMap collectionMap = (HashMap)collectionsList.get(t);
            String crsText = null;
            if (collectionMap.containsKey("crs")) {
                crsText = collectionMap.get("crs").toString();
            } else if (collectionMap.containsKey("extent")) {
                HashMap extentMap = (HashMap)collectionMap.get("extent");
                HashMap spatialMap = (HashMap)extentMap.get("spatial");
                crsText = spatialMap.get("crs").toString();
            }
            if (crsText.contains("CRS:84") || crsText.contains("CRS84") || crsText.contains("EPSG:4326") || crsText.contains("WGS84") || crsText.contains("www.opengis.net/def/crs/OGC/1.3/CRS84")) {
                compliesWithCRS84Requirement = true;
                continue;
            }
            compliesWithCRS84Requirement = false;
            resultMessage.append("Collection " + collectionMap.get("id").toString() + " fails. ");
        }
        Assert.assertTrue((boolean)compliesWithCRS84Requirement, (String)("Fails Abstract Test 8 because " + resultMessage.toString()));
    }

    private void crsChecking_NotUsed(ArrayList crsList) {
        boolean compliesWithCRS84Requirement = true;
        StringBuffer resultMessage = new StringBuffer();
        boolean supportsCRS84 = false;
        HashMap collectionMap = null;
        HashMap crsMap = (HashMap)crsList.get(0);
        CoordinateReferenceSystem source = null;
        try {
            source = CRS.fromWKT((String)crsMap.get("wkt").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GeographicCRS crs = (GeographicCRS)source;
        if ((crs.getDatum().getEllipsoid().getName().toString().equals("WGS 84") || crs.getDatum().getEllipsoid().getName().toString().equals("WGS_1984") || crs.getDatum().getEllipsoid().getName().toString().equals("WGS84")) && source.getCoordinateSystem().getAxis(0).toString().toLowerCase().contains("longitude") && source.getCoordinateSystem().getAxis(1).toString().toLowerCase().contains("latitude")) {
            supportsCRS84 = true;
        }
        if (!supportsCRS84) {
            compliesWithCRS84Requirement = false;
            resultMessage.append("Collection " + collectionMap.get("id").toString() + " fails. ");
        }
    }

    @Test(description="Implements Abstract Test 17 (/conf/edr/rc-parameters)")
    public void collectionsParameters() {
        boolean compliesWithCollectionParametersRequirement = true;
        StringBuffer resultMessage = new StringBuffer();
        Response response = this.getCollectionResponse(null);
        JsonPath jsonPath = response.jsonPath();
        List collectionsList = jsonPath.getList("collections");
        boolean atLeastOneCollectionIsEDR = false;
        for (int t = 0; t < collectionsList.size(); ++t) {
            HashMap collectionMap = (HashMap)collectionsList.get(t);
            if (collectionMap.containsKey("itemType") || !collectionMap.containsKey("parameter_names")) continue;
            atLeastOneCollectionIsEDR = true;
            String parameterNameText = collectionMap.get("parameter_names").toString();
            HashMap parameterNameMap = (HashMap)collectionMap.get("parameter_names");
            ArrayList<String> parameterNameList = new ArrayList<String>();
            for (Object k : parameterNameMap.keySet()) {
                if (parameterNameList.contains(k.toString())) {
                    Assert.fail((String)("Fails Abstract Test 17 because the parameter " + k.toString() + " is duplicated in collection " + collectionMap.get("id")));
                    continue;
                }
                parameterNameList.add(k.toString());
            }
            for (int i = 0; i < parameterNameList.size(); ++i) {
                String parameterName = (String)parameterNameList.get(i);
                HashMap parameterValueMap = (HashMap)parameterNameMap.get(parameterName);
                boolean hasType = parameterValueMap.containsKey("type");
                boolean hasObservedProperty = parameterValueMap.containsKey("observedProperty");
                Assert.assertTrue((boolean)hasType, (String)("Fails Abstract Test 17 because parameter " + parameterName + " in collection " + collectionMap.get("id") + " is missing a 'type' property"));
                Assert.assertTrue((boolean)hasObservedProperty, (String)("Fails Abstract Test 17 because parameter " + parameterName + " in collection " + collectionMap.get("id") + " is missing a 'observedProperty' property"));
            }
            Assert.assertTrue((boolean)compliesWithCollectionParametersRequirement, (String)("Fails Abstract Test 17 because " + resultMessage.toString()));
        }
    }

    @Test(description="Implements Abstract Test 13 (/conf/core/rc-extent), Abstract Test 14 (/conf/edr/rc-collection-info), Abstract Test 15 (/conf/edr/rc-md-query-links), Abstract Test 16 (/conf/core/rc-collection-info-links)")
    public void verifyCollectionsMetadata() {
        StringBuffer resultMessageForSelfAndAlternateLinks = new StringBuffer();
        StringBuffer resultMessageForDataOrCollectionLinks = new StringBuffer();
        StringBuffer resultMessageForCollectionId = new StringBuffer();
        StringBuffer resultMessageForCollectionExtent = new StringBuffer();
        Response response = this.getCollectionResponse(null);
        JsonPath jsonPath = response.jsonPath();
        List collectionsList = jsonPath.getList("collections");
        for (int t = 0; t < collectionsList.size(); ++t) {
            JsonPath jsonPathCol;
            boolean collectionHasSelfAndAlternateLinks = false;
            boolean collectionHasDataOrCollectionLinks = false;
            boolean collectionHasID = false;
            boolean collectionHasValidExtent = false;
            HashMap collectionMap = (HashMap)collectionsList.get(t);
            if (collectionMap.containsKey("itemType")) continue;
            if (!collectionMap.containsKey("id")) {
                resultMessageForCollectionId.append(collectionMap.get("id").toString() + " , ");
            }
            if (!this.checkExtentInCollection(jsonPathCol = this.getCollectionMetadata(collectionMap.get("id").toString()))) {
                resultMessageForCollectionExtent.append(collectionMap.get("id").toString() + " , ");
            }
            List linksList1 = jsonPathCol.getList("links");
            linksList1.addAll((ArrayList)collectionMap.get("links"));
            collectionHasDataOrCollectionLinks = this.checkDataOrCollectionLinksArePresentInCollectionMetadata(linksList1);
            collectionHasSelfAndAlternateLinks = this.checkSelfAndAlternateLinksArePresentInCollectionMetadata(linksList1);
            if (!collectionHasSelfAndAlternateLinks) {
                resultMessageForSelfAndAlternateLinks.append(collectionMap.get("id").toString() + " , ");
            }
            if (collectionHasDataOrCollectionLinks) continue;
            resultMessageForDataOrCollectionLinks.append(collectionMap.get("id").toString() + " , ");
        }
        StringBuffer resultMessage = new StringBuffer();
        if (!resultMessageForCollectionExtent.toString().isEmpty()) {
            resultMessage.append("Fails Abstract Test 13 because these collections have invalid or missing extent elements: " + resultMessageForCollectionExtent.toString() + ". ");
        }
        if (!resultMessageForCollectionId.toString().isEmpty()) {
            resultMessage.append("Fails Abstract Test 14 because these collections are missing 'id' properties: " + resultMessageForCollectionId.toString() + ". ");
        }
        if (!resultMessageForDataOrCollectionLinks.toString().isEmpty()) {
            resultMessage.append("Fails Abstract Test 15 because these collections are missing 'data' or 'collection' rel links: " + resultMessageForDataOrCollectionLinks.toString() + ". ");
        }
        if (!resultMessageForSelfAndAlternateLinks.toString().isEmpty()) {
            resultMessage.append("Fails Abstract Test 16 because these collections are missing 'self' or 'alternate' rel links: " + resultMessageForSelfAndAlternateLinks.toString() + ". ");
        }
        Assert.assertTrue((boolean)resultMessage.toString().isEmpty(), (String)resultMessage.toString());
    }

    private boolean checkExtentInCollection(JsonPath jsonPathCol) {
        HashMap extentMap = (HashMap)jsonPathCol.get("extent");
        return extentMap.containsKey("spatial");
    }

    private JsonPath getCollectionMetadata(String collectionId) {
        Response response = this.getCollectionResponse(collectionId);
        JsonPath jsonPath = response.jsonPath();
        return jsonPath;
    }

    private boolean checkSelfAndAlternateLinksArePresentInCollectionMetadata(List<Object> linksList) {
        boolean hasSelfRel = false;
        boolean hasAlternateRel = false;
        for (int w = 0; w < linksList.size(); ++w) {
            HashMap linksMap = (HashMap)linksList.get(w);
            if (linksMap.get("rel").toString().equals("self")) {
                hasSelfRel = true;
            }
            if (!linksMap.get("rel").toString().equals("alternate")) continue;
            hasAlternateRel = true;
        }
        return hasSelfRel || hasAlternateRel;
    }

    private boolean checkDataOrCollectionLinksArePresentInCollectionMetadata(List<Object> linksList) {
        boolean hasDataRel = false;
        boolean hasCollectionRel = false;
        for (int w = 0; w < linksList.size(); ++w) {
            HashMap linksMap = (HashMap)linksList.get(w);
            if (linksMap.get("rel").toString().equals("data")) {
                hasDataRel = true;
            }
            if (!linksMap.get("rel").toString().equals("collection")) continue;
            hasCollectionRel = true;
        }
        return hasDataRel || hasCollectionRel;
    }
}

