/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapiedr10.encodings.geojson;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opengis.cite.ogcapiedr10.CommonFixture;
import org.opengis.cite.ogcapiedr10.EtsAssert;
import org.opengis.cite.ogcapiedr10.SuiteAttribute;
import org.opengis.cite.ogcapiedr10.conformance.RequirementClass;
import org.opengis.cite.ogcapiedr10.encodings.geojson.GeoJSONValidator;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class GeoJSONEncoding
extends CommonFixture {
    protected URI iut;

    @Test(description="Implements Abstract Test 20 (/conf/geojson/definition), Abstract Test 21 (/conf/geojson/content)")
    public void validateResponseForGeoJSON(ITestContext testContext) {
        List requirementClasses = (List)testContext.getSuite().getAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName());
        if (!requirementClasses.contains((Object)RequirementClass.GEOJSON)) {
            throw new SkipException(String.format("Requirements class %s not implemented.", RequirementClass.GEOJSON.getConformanceClass()));
        }
        StringBuffer sb = new StringBuffer();
        boolean atLeastOneCollectionTested = false;
        Response response = this.getCollectionResponse(null);
        JsonPath jsonResponse = response.jsonPath();
        ArrayList collectionsList = (ArrayList)jsonResponse.getList("collections");
        for (int i = 0; i < collectionsList.size() && !atLeastOneCollectionTested; ++i) {
            HashMap dataQueries;
            boolean supportsLocationsQuery;
            HashMap collectionItem = (HashMap)collectionsList.get(i);
            if (!collectionItem.containsKey("data_queries") || !(supportsLocationsQuery = (dataQueries = (HashMap)collectionItem.get("data_queries")).containsKey("locations"))) continue;
            HashMap locationsQuery = (HashMap)dataQueries.get("locations");
            HashMap link = (HashMap)locationsQuery.get("link");
            HashMap variables = (HashMap)link.get("variables");
            ArrayList outputFormatList = (ArrayList)variables.get("output_formats");
            String supportedFormat = null;
            for (int f = 0; f < outputFormatList.size(); ++f) {
                if (!((String)outputFormatList.get(f)).equalsIgnoreCase("GeoJSON")) continue;
                supportedFormat = (String)outputFormatList.get(f);
            }
            try {
                if (supportedFormat == null) continue;
                String locationsURL = link.get("href").toString() + "?f=" + supportedFormat;
                GeoJSONValidator validator = new GeoJSONValidator();
                boolean result = validator.isGeoJSONValidPerSchema(locationsURL, -1);
                atLeastOneCollectionTested = true;
                if (result) continue;
                sb.append(" None of the collections with locations resources were found to offer GeoJSON encoded responses.\n");
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sb.append(" " + ex.getMessage() + "\n");
            }
        }
        EtsAssert.assertTrue(atLeastOneCollectionTested, "Fails Abstract Test 21. None of the collections were found to offer Locations resources that return valid GeoJSON\n");
    }
}

