/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.jts.Factory;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.display.shape.ShapeUtilities;
import org.geotoolkit.geometry.SampledByPoints;
import org.geotoolkit.referencing.ReferencingUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeometricUtilities {
    private GeometricUtilities() {
    }

    public static GeometryFactory getFactory() {
        return Factory.INSTANCE.factory(false);
    }

    public static double bboxToPointDistance(GeneralEnvelope boundingBox, GeneralDirectPosition point, String units) {
        if (boundingBox.contains((DirectPosition)point)) {
            return 0.0;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        double distance = Double.MAX_VALUE;
        for (Line2D l : border) {
            double tempDistance = GeometricUtilities.lineToPointDistance(l, point, units);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public static double lineToPointDistance(Line2D line, GeneralDirectPosition point, String units) {
        Point2D.Double pt = ShapeUtilities.nearestColinearPoint(line, new Point2D.Double(point.getOrdinate(0), point.getOrdinate(1)));
        return GeometricUtilities.getOrthodromicDistance(point.getOrdinate(0), point.getOrdinate(1), ((Point2D)pt).getX(), ((Point2D)pt).getY(), units);
    }

    public static double lineTolineDistance(Line2D line1, Line2D line2, String units) {
        double distance = Double.MAX_VALUE;
        if (line1.intersectsLine(line2)) {
            return 0.0;
        }
        Point2D.Double pt = ShapeUtilities.nearestColinearPoint(line2, line1.getP1());
        double tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)pt).getX(), ((Point2D)pt).getY(), line1.getX1(), line1.getY1(), units);
        if (tempDistance < distance) {
            distance = tempDistance;
        }
        if ((tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)(pt = ShapeUtilities.nearestColinearPoint(line2, line1.getP2()))).getX(), ((Point2D)pt).getY(), line1.getX2(), line1.getY2(), units)) < distance) {
            distance = tempDistance;
        }
        if ((tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)(pt = ShapeUtilities.nearestColinearPoint(line1, line2.getP1()))).getX(), ((Point2D)pt).getY(), line2.getX1(), line2.getY1(), units)) < distance) {
            distance = tempDistance;
        }
        if ((tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)(pt = ShapeUtilities.nearestColinearPoint(line1, line2.getP2()))).getX(), ((Point2D)pt).getY(), line2.getX2(), line2.getY2(), units)) < distance) {
            distance = tempDistance;
        }
        return distance;
    }

    public static double lineToBBoxDistance(Line2D line, GeneralEnvelope boundingBox, String units) {
        CoordinateReferenceSystem crs = boundingBox.getCoordinateReferenceSystem();
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(new double[]{line.getX1(), line.getY1()});
        tempPoint1.setCoordinateReferenceSystem(crs);
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(new double[]{line.getX2(), line.getY2()});
        tempPoint2.setCoordinateReferenceSystem(crs);
        if (boundingBox.contains((DirectPosition)tempPoint1) || boundingBox.contains((DirectPosition)tempPoint2)) {
            return 0.0;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        double distance = Double.MAX_VALUE;
        for (Line2D l : border) {
            if (l.intersectsLine(line)) {
                return 0.0;
            }
            double tempDistance = GeometricUtilities.lineTolineDistance(l, line, units);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public static double bboxToBBoxDistance(GeneralEnvelope boundingBox1, GeneralEnvelope boundingBox2, String units) {
        if (boundingBox1.intersects((Envelope)boundingBox2, false)) {
            return 0.0;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox1);
        double distance = Double.MAX_VALUE;
        for (Line2D l : border) {
            double tempDistance = GeometricUtilities.lineToBBoxDistance(l, boundingBox2, units);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public static double getOrthodromicDistance(double x1, double y1, double x2, double y2, String units) {
        double result = ReferencingUtilities.orthodromicDistance(6371007.0, y1, x1, y2, x2);
        if (units.equals("meters") || units.equals("m")) {
            return result;
        }
        if (units.equals("kilometers") || units.equals("km")) {
            return result / 1000.0;
        }
        if (units.equals("centimeters") || units.equals("cm")) {
            return result * 100.0;
        }
        if (units.equals("milimeters") || units.equals("mm")) {
            return result * 1000.0;
        }
        if (units.equals("miles") || units.equals("mi")) {
            return result * 0.621371 / 1000.0;
        }
        throw new IllegalArgumentException("unknow distance units");
    }

    public static List<Line2D> getBorder(Object geometry) {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        if (geometry instanceof GeneralEnvelope) {
            GeneralEnvelope env = (GeneralEnvelope)geometry;
            Line2D.Double heightLeft = new Line2D.Double(env.getMinimum(0), env.getMaximum(1), env.getMinimum(0), env.getMinimum(1));
            result.add(heightLeft);
            Line2D.Double widthTop = new Line2D.Double(env.getMinimum(0), env.getMaximum(1), env.getMaximum(0), env.getMaximum(1));
            result.add(widthTop);
            Line2D.Double heightRight = new Line2D.Double(env.getMaximum(0), env.getMaximum(1), env.getMaximum(0), env.getMinimum(1));
            result.add(heightRight);
            Line2D.Double widthBottom = new Line2D.Double(env.getMinimum(0), env.getMinimum(1), env.getMaximum(0), env.getMinimum(1));
            result.add(widthBottom);
        }
        return result;
    }

    public static List<Point2D> getCorner(Object geometry) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        if (geometry instanceof GeneralEnvelope) {
            GeneralEnvelope env = (GeneralEnvelope)geometry;
            Point2D.Double upperLeft = new Point2D.Double(env.getMinimum(0), env.getMaximum(1));
            result.add(upperLeft);
            Point2D.Double upperRight = new Point2D.Double(env.getMaximum(0), env.getMaximum(1));
            result.add(upperRight);
            Point2D.Double bottomRight = new Point2D.Double(env.getMaximum(0), env.getMinimum(1));
            result.add(bottomRight);
            Point2D.Double bottomLeft = new Point2D.Double(env.getMinimum(0), env.getMinimum(1));
            result.add(bottomLeft);
        }
        return result;
    }

    public static PointArray getSamplePoints(CurveSegment lineString) {
        if (lineString instanceof SampledByPoints) {
            return ((SampledByPoints)lineString).getSamplePoints();
        }
        throw new IllegalArgumentException(lineString.getClass() + " is not an instance of SampledByPoints.");
    }

    public static boolean touches(GeneralEnvelope boundingBox, GeneralDirectPosition point) {
        if (point == null || boundingBox == null) {
            return false;
        }
        Line2D.Double pointLine = new Line2D.Double(point.getOrdinate(0), point.getOrdinate(1), point.getOrdinate(0), point.getOrdinate(1));
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        for (Line2D l : border) {
            if (!l.intersectsLine(pointLine)) continue;
            return true;
        }
        return false;
    }

    public static boolean touches(Line2D line1, Line2D line2) {
        if (line1 == null || line2 == null) {
            return false;
        }
        return line1.intersectsLine(new Line2D.Double(line2.getX1(), line2.getY1(), line2.getX1(), line2.getY1())) || line1.intersectsLine(new Line2D.Double(line2.getX2(), line2.getY2(), line2.getX2(), line2.getY2())) || line2.intersectsLine(new Line2D.Double(line1.getX1(), line1.getY1(), line1.getX1(), line1.getY1())) || line2.intersectsLine(new Line2D.Double(line1.getX2(), line1.getY2(), line1.getX2(), line1.getY2()));
    }

    public static boolean touches(GeneralEnvelope boundingBox, Line2D line) {
        if (line == null || boundingBox == null) {
            return false;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        for (Line2D l : border) {
            if (!l.intersectsLine(line.getX1(), line.getY1(), line.getX1(), line.getY1()) && !l.intersectsLine(line.getX2(), line.getY2(), line.getX2(), line.getY2())) continue;
            return true;
        }
        return false;
    }

    public static boolean touches(GeneralEnvelope boundingBox1, GeneralEnvelope boundingBox2) {
        if (boundingBox1 == null || boundingBox2 == null) {
            return false;
        }
        boolean touches = false;
        List<Line2D> bboxBorder1 = GeometricUtilities.getBorder(boundingBox1);
        for (Line2D l : bboxBorder1) {
            for (Point2D p : GeometricUtilities.getCorner(boundingBox2)) {
                if (!l.intersectsLine(p.getX(), p.getY(), p.getX(), p.getY())) continue;
                touches = true;
            }
        }
        List<Point2D> filterBoxCorner = GeometricUtilities.getCorner(boundingBox1);
        for (Line2D l : GeometricUtilities.getBorder(boundingBox2)) {
            for (Point2D p : filterBoxCorner) {
                if (!l.intersectsLine(p.getX(), p.getY(), p.getX(), p.getY())) continue;
                touches = true;
            }
        }
        return touches;
    }

    public static boolean disjoint(GeneralEnvelope boundingBox, Line2D line) {
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(new double[]{line.getX1(), line.getY1()});
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(new double[]{line.getX2(), line.getY2()});
        if (!boundingBox.contains((DirectPosition)tempPoint1) && !boundingBox.contains((DirectPosition)tempPoint2)) {
            List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
            for (Line2D l : border) {
                if (!l.intersectsLine(line)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean intersect(GeneralEnvelope boundingBox, Line2D line) {
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(new double[]{line.getX1(), line.getY1()});
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(new double[]{line.getX2(), line.getY2()});
        if (boundingBox.contains((DirectPosition)tempPoint1) || boundingBox.contains((DirectPosition)tempPoint2)) {
            return true;
        }
        for (Line2D l : GeometricUtilities.getBorder(boundingBox)) {
            if (!l.intersectsLine(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean crosses(GeneralEnvelope boundingBox, Line2D line) {
        CoordinateReferenceSystem crs = boundingBox.getCoordinateReferenceSystem();
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(new double[]{line.getX1(), line.getY1()});
        tempPoint1.setCoordinateReferenceSystem(crs);
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(new double[]{line.getX2(), line.getY2()});
        tempPoint2.setCoordinateReferenceSystem(crs);
        return boundingBox.contains((DirectPosition)tempPoint1) && !boundingBox.contains((DirectPosition)tempPoint2) || !boundingBox.contains((DirectPosition)tempPoint1) && boundingBox.contains((DirectPosition)tempPoint2);
    }

    public static boolean crosses(GeneralEnvelope boundingBox, GeneralDirectPosition point) {
        for (Line2D l : GeometricUtilities.getBorder(boundingBox)) {
            if (!l.intersectsLine(point.getOrdinate(0), point.getOrdinate(1), point.getOrdinate(0), point.getOrdinate(1))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(GeneralEnvelope boundingBox, Line2D line) {
        CoordinateReferenceSystem crs = boundingBox.getCoordinateReferenceSystem();
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(new double[]{line.getX1(), line.getY1()});
        tempPoint1.setCoordinateReferenceSystem(crs);
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(new double[]{line.getX2(), line.getY2()});
        tempPoint2.setCoordinateReferenceSystem(crs);
        return boundingBox.contains((DirectPosition)tempPoint1) && boundingBox.contains((DirectPosition)tempPoint2);
    }

    public static boolean overlaps(GeneralEnvelope boundingBox1, GeneralEnvelope boundingBox2) {
        if (boundingBox1.contains((Envelope)boundingBox2, true) || boundingBox2.contains((Envelope)boundingBox1, true)) {
            return false;
        }
        return boundingBox1.intersects((Envelope)boundingBox2, true);
    }

    public static boolean equalsLine(Line2D l1, Line2D l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        return l1.getX1() == l2.getX1() && l1.getX2() == l2.getX2() && l1.getY1() == l2.getY1() && l1.getY2() == l2.getY2();
    }

    public static String logLine2D(Line2D line) {
        if (line == null) {
            return "null";
        }
        return "x1=" + line.getX1() + " y1=" + line.getY1() + " x2=" + line.getX2() + " y2=" + line.getY2();
    }

    public static Object reprojectGeometry(String targetCRSName, String sourceCRSName, Object geometry) throws NoSuchAuthorityCodeException, FactoryException, TransformException {
        AbstractCRS targetCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)CRS.forCode((String)targetCRSName)).forConvention(AxesConvention.RIGHT_HANDED);
        AbstractCRS sourceCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)CRS.forCode((String)sourceCRSName)).forConvention(AxesConvention.RIGHT_HANDED);
        if (geometry instanceof GeneralEnvelope) {
            GeneralEnvelope env = (GeneralEnvelope)geometry;
            if (env.getCoordinateReferenceSystem() == null) {
                env.setCoordinateReferenceSystem((CoordinateReferenceSystem)sourceCRS);
            }
            return Envelopes.transform((Envelope)((GeneralEnvelope)geometry), (CoordinateReferenceSystem)targetCRS);
        }
        if (geometry instanceof GeneralDirectPosition) {
            CoordinateOperation operation;
            try {
                operation = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null);
            }
            catch (FactoryException exception) {
                throw new TransformException("transform exception: " + exception.getMessage());
            }
            MathTransform mt = operation.getMathTransform();
            mt.transform((DirectPosition)((GeneralDirectPosition)geometry), (DirectPosition)((GeneralDirectPosition)geometry));
            return geometry;
        }
        if (geometry instanceof Line2D) {
            CoordinateOperation operation;
            Line2D line = (Line2D)geometry;
            GeneralDirectPosition pt1 = new GeneralDirectPosition(new double[]{line.getX1(), line.getY1()});
            GeneralDirectPosition pt2 = new GeneralDirectPosition(new double[]{line.getX2(), line.getY2()});
            try {
                operation = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, null);
            }
            catch (FactoryException exception) {
                throw new TransformException("transform exception: " + exception.getMessage());
            }
            MathTransform mt = operation.getMathTransform();
            mt.transform((DirectPosition)pt1, (DirectPosition)pt1);
            mt.transform((DirectPosition)pt2, (DirectPosition)pt2);
            return new Line2D.Double(pt1.getOrdinate(0), pt1.getOrdinate(1), pt2.getOrdinate(0), pt2.getOrdinate(1));
        }
        throw new IllegalArgumentException("Unknow geometry types: allowed ones are: GeneralEnvelope, Line2D, GeneralDirectPosition");
    }

    public static Object reprojectBbox2DString(String sourceCRSName, String targetCRSName, String boundingBox) throws NoSuchAuthorityCodeException, FactoryException, TransformException {
        String[] bbox = boundingBox.split(",");
        double[] lowerCorner = new double[]{Double.parseDouble(bbox[1]), Double.parseDouble(bbox[0])};
        double[] upperCorner = new double[]{Double.parseDouble(bbox[3]), Double.parseDouble(bbox[2])};
        GeneralEnvelope env = new GeneralEnvelope(lowerCorner, upperCorner);
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)AbstractCRS.castOrCopy((CoordinateReferenceSystem)CRS.forCode((String)sourceCRSName)).forConvention(AxesConvention.RIGHT_HANDED));
        env = (GeneralEnvelope)GeometricUtilities.reprojectGeometry(targetCRSName, sourceCRSName, env);
        lowerCorner = env.getLowerCorner().getCoordinate();
        upperCorner = env.getUpperCorner().getCoordinate();
        return lowerCorner[0] + "," + lowerCorner[1] + "," + upperCorner[0] + "," + upperCorner[1];
    }

    public static Geometry toJTSGeometry(Envelope env, WrapResolution resolution) {
        return GeometricUtilities.toJTSGeometry(env, resolution, true, null);
    }

    public static Geometry toJTSGeometry(Envelope env, WrapResolution resolution, GeometryFactory gf) {
        return GeometricUtilities.toJTSGeometry(env, resolution, true, gf);
    }

    public static Geometry toJTSGeometry(Envelope env, WrapResolution resolution, boolean insertMedianPoints) {
        return GeometricUtilities.toJTSGeometry(env, resolution, insertMedianPoints, null);
    }

    public static Geometry toJTSGeometry(Envelope env, WrapResolution resolution, boolean insertMedianPoints, GeometryFactory gf) {
        boolean wrapOnY;
        ArgumentChecks.ensureNonNull((String)"resolution", (Object)((Object)resolution));
        if (gf == null) {
            gf = GeometricUtilities.getFactory();
        }
        if (WrapResolution.NONE == resolution) {
            double minX = env.getMinimum(0);
            double minY = env.getMinimum(1);
            double maxX = env.getMaximum(0);
            double maxY = env.getMaximum(1);
            Coordinate[] coordinates = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)};
            return gf.createPolygon(gf.createLinearRing(coordinates), new LinearRing[0]);
        }
        CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
        GeneralEnvelope genv = new GeneralEnvelope(env);
        genv.normalize();
        if (WrapResolution.EXPAND == resolution) {
            genv.simplify();
            double minX = genv.getMinimum(0);
            double minY = genv.getMinimum(1);
            double maxX = genv.getMaximum(0);
            double maxY = genv.getMaximum(1);
            return GeometricUtilities.builEnvelopePiece(minX, minY, maxX, maxY, crs, insertMedianPoints, gf);
        }
        boolean wrapOnX = genv.getLowerCorner().getOrdinate(0) > genv.getUpperCorner().getOrdinate(0);
        boolean bl = wrapOnY = genv.getLowerCorner().getOrdinate(1) > genv.getUpperCorner().getOrdinate(1);
        if (!wrapOnX && !wrapOnY) {
            double minX = env.getMinimum(0);
            double minY = env.getMinimum(1);
            double maxX = env.getMaximum(0);
            double maxY = env.getMaximum(1);
            return GeometricUtilities.builEnvelopePiece(minX, minY, maxX, maxY, crs, insertMedianPoints, gf);
        }
        CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(wrapOnX ? 0 : 1);
        double axisMin = axis.getMinimumValue();
        double axisMax = axis.getMaximumValue();
        double wrapRange = axis.getMaximumValue() - axis.getMinimumValue();
        DirectPosition lowerCorner = genv.getLowerCorner();
        DirectPosition upperCorner = genv.getUpperCorner();
        if (WrapResolution.SPLIT == resolution) {
            double maxY;
            double maxX;
            double minY;
            double minX;
            if (wrapOnX) {
                minX = axisMin;
                minY = lowerCorner.getOrdinate(1);
                maxX = upperCorner.getOrdinate(0);
                maxY = upperCorner.getOrdinate(1);
            } else {
                minX = lowerCorner.getOrdinate(0);
                minY = axisMin;
                maxX = upperCorner.getOrdinate(0);
                maxY = upperCorner.getOrdinate(1);
            }
            Polygon leftpoly = GeometricUtilities.builEnvelopePiece(minX, minY, maxX, maxY, crs, insertMedianPoints, gf);
            if (wrapOnX) {
                minX = lowerCorner.getOrdinate(0);
                minY = lowerCorner.getOrdinate(1);
                maxX = axisMax;
                maxY = upperCorner.getOrdinate(1);
            } else {
                minX = lowerCorner.getOrdinate(0);
                minY = lowerCorner.getOrdinate(1);
                maxX = upperCorner.getOrdinate(0);
                maxY = axisMax;
            }
            Polygon rightpoly = GeometricUtilities.builEnvelopePiece(minX, minY, maxX, maxY, crs, insertMedianPoints, gf);
            return gf.createMultiPolygon(new Polygon[]{leftpoly, rightpoly});
        }
        if (WrapResolution.CONTIGUOUS == resolution) {
            double maxY;
            double maxX;
            double minY;
            double minX;
            if (wrapOnX) {
                minX = lowerCorner.getOrdinate(0);
                minY = lowerCorner.getOrdinate(1);
                maxX = upperCorner.getOrdinate(0) + wrapRange;
                maxY = upperCorner.getOrdinate(1);
            } else {
                minX = lowerCorner.getOrdinate(0);
                minY = lowerCorner.getOrdinate(1);
                maxX = upperCorner.getOrdinate(0);
                maxY = upperCorner.getOrdinate(1) + wrapRange;
            }
            return GeometricUtilities.builEnvelopePiece(minX, minY, maxX, maxY, crs, insertMedianPoints, gf);
        }
        throw new IllegalArgumentException("Unknowed or unset wrap resolution : " + resolution);
    }

    private static Polygon builEnvelopePiece(double minX, double minY, double maxX, double maxY, CoordinateReferenceSystem crs, boolean insertMedianPoints, GeometryFactory gf) {
        int i;
        boolean wrapOnX;
        DirectPosition[] wrapPoints;
        if (gf == null) {
            gf = GeometricUtilities.getFactory();
        }
        try {
            wrapPoints = ReferencingUtilities.findWrapAround(crs);
        }
        catch (TransformException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        if (!insertMedianPoints || wrapPoints == null) {
            return GeometricUtilities.buildEnvelope(minX, minY, maxX, maxY, gf);
        }
        boolean bl = wrapOnX = wrapPoints[0].getOrdinate(0) != 0.0 || wrapPoints[1].getOrdinate(0) != 0.0;
        if (wrapOnX) {
            int i2;
            double envRange = maxX - minX;
            double wrapRange = wrapPoints[1].getOrdinate(0) - wrapPoints[0].getOrdinate(0);
            int nbPoint = (int)(envRange / (wrapRange / 2.0));
            if (nbPoint == 0) {
                return GeometricUtilities.buildEnvelope(minX, minY, maxX, maxY, gf);
            }
            Coordinate[] coordinates = new Coordinate[5 + 2 * nbPoint];
            int index = 0;
            coordinates[index++] = new Coordinate(minX, minY);
            coordinates[index++] = new Coordinate(minX, maxY);
            for (i2 = 0; i2 < nbPoint; ++i2) {
                coordinates[index++] = new Coordinate(minX + (double)(i2 + 1) * (envRange / (double)(nbPoint + 1)), maxY);
            }
            coordinates[index++] = new Coordinate(maxX, maxY);
            coordinates[index++] = new Coordinate(maxX, minY);
            for (i2 = 0; i2 < nbPoint; ++i2) {
                coordinates[index++] = new Coordinate(maxX - (double)(i2 + 1) * (envRange / (double)(nbPoint + 1)), minY);
            }
            coordinates[index++] = new Coordinate(minX, minY);
            return gf.createPolygon(gf.createLinearRing(coordinates), new LinearRing[0]);
        }
        double envRange = maxY - minY;
        double wrapRange = wrapPoints[1].getOrdinate(1) - wrapPoints[0].getOrdinate(1);
        int nbPoint = (int)(envRange / wrapRange);
        if (nbPoint == 0) {
            return GeometricUtilities.buildEnvelope(minX, minY, maxX, maxY, gf);
        }
        Coordinate[] coordinates = new Coordinate[5 + 2 * nbPoint];
        int index = 0;
        coordinates[index++] = new Coordinate(minX, minY);
        for (i = 0; i < nbPoint; ++i) {
            coordinates[index++] = new Coordinate(minX, maxY + (double)(i + 1) * (envRange / (double)(nbPoint + 1)));
        }
        coordinates[index++] = new Coordinate(minX, maxY);
        coordinates[index++] = new Coordinate(maxX, maxY);
        for (i = 0; i < nbPoint; ++i) {
            coordinates[index++] = new Coordinate(maxX, maxY - (double)(i + 1) * (envRange / (double)(nbPoint + 1)));
        }
        coordinates[index++] = new Coordinate(maxX, minY);
        coordinates[index++] = new Coordinate(minX, minY);
        return gf.createPolygon(gf.createLinearRing(coordinates), new LinearRing[0]);
    }

    private static Polygon buildEnvelope(double minX, double minY, double maxX, double maxY, GeometryFactory gf) {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)};
        return gf.createPolygon(gf.createLinearRing(coordinates), new LinearRing[0]);
    }

    public static enum WrapResolution {
        NONE,
        EXPAND,
        SPLIT,
        CONTIGUOUS;

    }
}

