/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.sis.filter.BinaryFunction;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.filter.BetweenComparisonOperator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ComparisonOperatorName;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.MatchAction;

abstract class ComparisonFilter<R>
extends BinaryFunction<R, Object, Object>
implements BinaryComparisonOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 1228683039737814926L;
    protected final boolean isMatchingCase;
    protected final MatchAction matchAction;

    ComparisonFilter(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
        super(expression1, expression2);
        this.isMatchingCase = isMatchingCase;
        this.matchAction = matchAction;
        ArgumentChecks.ensureNonNull("matchAction", matchAction);
    }

    public final Expression<R, ?> getOperand1() {
        return this.expression1;
    }

    public final Expression<R, ?> getOperand2() {
        return this.expression2;
    }

    public final boolean isMatchingCase() {
        return this.isMatchingCase;
    }

    public final MatchAction getMatchAction() {
        return this.matchAction;
    }

    @Override
    public final int hashCode() {
        return super.hashCode() + Boolean.hashCode(this.isMatchingCase) + 61 * this.matchAction.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (super.equals(obj)) {
            ComparisonFilter other = (ComparisonFilter)obj;
            return other.isMatchingCase == this.isMatchingCase && this.matchAction.equals((Object)other.matchAction);
        }
        return false;
    }

    public final boolean test(R candidate) {
        Object right;
        Object left = this.expression1.apply(candidate);
        if (left != null && (right = this.expression2.apply(candidate)) != null) {
            Iterable collection;
            boolean collectionFirst = left instanceof Iterable;
            if (collectionFirst) {
                if (right instanceof Iterable) {
                    return false;
                }
                collection = (Iterable)left;
            } else if (right instanceof Iterable) {
                collection = (Iterable)right;
            } else {
                return this.evaluate(left, right);
            }
            boolean match = false;
            block5: for (Object element : collection) {
                if (element == null) continue;
                boolean pass = collectionFirst ? this.evaluate(element, right) : this.evaluate(left, element);
                switch (this.matchAction) {
                    default: {
                        return false;
                    }
                    case ALL: {
                        if (!pass) {
                            return false;
                        }
                        match = true;
                        continue block5;
                    }
                    case ANY: {
                        if (!pass) continue block5;
                        return true;
                    }
                    case ONE: 
                }
                if (!pass) continue;
                if (match) {
                    return false;
                }
                match = true;
            }
            return match;
        }
        return false;
    }

    private boolean evaluate(Object left, Object right) {
        Number r;
        if (left instanceof Number && right instanceof Number && (r = this.apply((Number)left, (Number)right)) != null) {
            return r.intValue() != 0;
        }
        if (left instanceof java.util.Date && right instanceof java.util.Date) {
            if (left.getClass() == right.getClass()) {
                return this.fromCompareTo(((java.util.Date)left).compareTo((java.util.Date)right));
            }
            left = ComparisonFilter.fromLegacy((java.util.Date)left);
            right = ComparisonFilter.fromLegacy((java.util.Date)right);
        }
        if (left instanceof Temporal || right instanceof Temporal) {
            Comparable<Instant> t;
            if (left instanceof Instant) {
                t = ComparisonFilter.toInstant(right);
                if (t != null) {
                    return this.fromCompareTo(((Instant)left).compareTo((Instant)t));
                }
            } else if (right instanceof Instant) {
                t = ComparisonFilter.toInstant(left);
                if (t != null) {
                    return this.fromCompareTo(((Instant)t).compareTo((Instant)right));
                }
            } else if (left instanceof OffsetDateTime) {
                t = ComparisonFilter.toOffsetDateTime(right);
                if (t != null) {
                    return this.compare((OffsetDateTime)left, (OffsetDateTime)t);
                }
            } else if (right instanceof OffsetDateTime) {
                t = ComparisonFilter.toOffsetDateTime(left);
                if (t != null) {
                    return this.compare((OffsetDateTime)t, (OffsetDateTime)right);
                }
            } else if (left instanceof OffsetTime && right instanceof OffsetTime) {
                return this.compare((OffsetTime)left, (OffsetTime)right);
            }
            if (left instanceof ChronoLocalDateTime) {
                t = ComparisonFilter.toLocalDateTime(right);
                if (t != null) {
                    return this.compare((ChronoLocalDateTime)left, (ChronoLocalDateTime<?>)t);
                }
            } else if (right instanceof ChronoLocalDateTime && (t = ComparisonFilter.toLocalDateTime(left)) != null) {
                return this.compare((ChronoLocalDateTime<?>)t, (ChronoLocalDateTime)right);
            }
            if (left instanceof ChronoLocalDate) {
                t = ComparisonFilter.toLocalDate(right);
                if (t != null) {
                    return this.compare((ChronoLocalDate)left, (ChronoLocalDate)t);
                }
            } else if (right instanceof ChronoLocalDate && (t = ComparisonFilter.toLocalDate(left)) != null) {
                return this.compare((ChronoLocalDate)t, (ChronoLocalDate)right);
            }
            if (left instanceof LocalTime) {
                t = ComparisonFilter.toLocalTime(right);
                if (t != null) {
                    return this.fromCompareTo(((LocalTime)left).compareTo((LocalTime)t));
                }
            } else if (right instanceof LocalTime && (t = ComparisonFilter.toLocalTime(left)) != null) {
                return this.fromCompareTo(((LocalTime)t).compareTo((LocalTime)right));
            }
        }
        if (left instanceof CharSequence || right instanceof CharSequence) {
            String s1 = left.toString();
            String s2 = right.toString();
            int result = this.isMatchingCase ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
            return this.fromCompareTo(result);
        }
        if (left.getClass() == right.getClass() && left instanceof Comparable) {
            int result = ((Comparable)left).compareTo(right);
            return this.fromCompareTo(result);
        }
        return false;
    }

    private static Temporal fromLegacy(java.util.Date value) {
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        return LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
    }

    static Instant toInstant(Object value) {
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toInstant();
        }
        if (value instanceof ChronoZonedDateTime) {
            return ((ChronoZonedDateTime)value).toInstant();
        }
        if (value instanceof java.util.Date) {
            try {
                return ((java.util.Date)value).toInstant();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        } else if (value instanceof Calendar) {
            return ((Calendar)value).toInstant();
        }
        return null;
    }

    private static OffsetDateTime toOffsetDateTime(Object value) {
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toOffsetDateTime();
        }
        return null;
    }

    private static ChronoLocalDateTime<?> toLocalDateTime(Object value) {
        if (value instanceof ChronoLocalDateTime) {
            return (ChronoLocalDateTime)value;
        }
        if (value instanceof ChronoZonedDateTime) {
            ComparisonFilter.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((ChronoZonedDateTime)value).toLocalDateTime();
        }
        if (value instanceof OffsetDateTime) {
            ComparisonFilter.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        return null;
    }

    private static ChronoLocalDate toLocalDate(Object value) {
        if (value instanceof ChronoLocalDate) {
            return (ChronoLocalDate)value;
        }
        if (value instanceof ChronoLocalDateTime) {
            ComparisonFilter.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((ChronoLocalDateTime)value).toLocalDate();
        }
        if (value instanceof ChronoZonedDateTime) {
            ComparisonFilter.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((ChronoZonedDateTime)value).toLocalDate();
        }
        if (value instanceof OffsetDateTime) {
            ComparisonFilter.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((OffsetDateTime)value).toLocalDate();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        return null;
    }

    private static LocalTime toLocalTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof OffsetTime) {
            ComparisonFilter.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((OffsetTime)value).toLocalTime();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        return null;
    }

    private static void ignoringField(ChronoField field) {
    }

    private static Number number(boolean result) {
        return result ? 1 : 0;
    }

    protected abstract boolean fromCompareTo(int var1);

    protected abstract boolean compare(OffsetTime var1, OffsetTime var2);

    protected abstract boolean compare(OffsetDateTime var1, OffsetDateTime var2);

    protected abstract boolean compare(ChronoLocalDate var1, ChronoLocalDate var2);

    protected abstract boolean compare(ChronoLocalDateTime<?> var1, ChronoLocalDateTime<?> var2);

    protected abstract boolean compare(ChronoZonedDateTime<?> var1, ChronoZonedDateTime<?> var2);

    @Override
    protected final Number applyAsDecimal(BigDecimal left, BigDecimal right) {
        return ComparisonFilter.number(this.fromCompareTo(left.compareTo(right)));
    }

    @Override
    protected final Number applyAsInteger(BigInteger left, BigInteger right) {
        return ComparisonFilter.number(this.fromCompareTo(left.compareTo(right)));
    }

    @Override
    protected final Number applyAsFraction(Fraction left, Fraction right) {
        return ComparisonFilter.number(this.fromCompareTo(left.compareTo(right)));
    }

    static final class Between<R>
    extends Node
    implements BetweenComparisonOperator<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -2434954008425799595L;
        private final GreaterThanOrEqualTo<R> lower;
        private final LessThanOrEqualTo<R> upper;

        Between(Expression<R, ?> expression, Expression<R, ?> lower, Expression<R, ?> upper) {
            this.lower = new GreaterThanOrEqualTo<R>(expression, lower, true, MatchAction.ANY);
            this.upper = new LessThanOrEqualTo<R>(expression, upper, true, MatchAction.ANY);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new Between<R>(effective[0], effective[1], effective[2]);
        }

        public final Class<? super R> getResourceClass() {
            return Between.specializedClass(this.lower.getResourceClass(), this.upper.getResourceClass());
        }

        @Override
        protected Collection<?> getChildren() {
            return this.getExpressions();
        }

        public List<Expression<R, ?>> getExpressions() {
            return List.of(this.getExpression(), this.getLowerBoundary(), this.getUpperBoundary());
        }

        public Expression<R, ?> getExpression() {
            return this.lower.expression1;
        }

        public Expression<R, ?> getLowerBoundary() {
            return this.lower.expression2;
        }

        public Expression<R, ?> getUpperBoundary() {
            return this.upper.expression2;
        }

        public boolean test(R object) {
            return this.lower.test(object) && this.upper.test(object);
        }
    }

    static final class NotEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = -3295957142249035362L;

        NotEqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new NotEqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2260';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result != 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left != right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left != right);
        }

        @Override
        protected boolean compare(OffsetTime left, OffsetTime right) {
            return !left.isEqual(right);
        }

        @Override
        protected boolean compare(OffsetDateTime left, OffsetDateTime right) {
            return !left.isEqual(right);
        }

        @Override
        protected boolean compare(ChronoLocalDate left, ChronoLocalDate right) {
            return !left.isEqual(right);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> left, ChronoLocalDateTime<?> right) {
            return !left.isEqual(right);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> left, ChronoZonedDateTime<?> right) {
            return !left.isEqual(right);
        }
    }

    static final class EqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 8502612221498749667L;

        EqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new EqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '=';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result == 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left == right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left == right);
        }

        @Override
        protected boolean compare(OffsetTime left, OffsetTime right) {
            return left.isEqual(right);
        }

        @Override
        protected boolean compare(OffsetDateTime left, OffsetDateTime right) {
            return left.isEqual(right);
        }

        @Override
        protected boolean compare(ChronoLocalDate left, ChronoLocalDate right) {
            return left.isEqual(right);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> left, ChronoLocalDateTime<?> right) {
            return left.isEqual(right);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> left, ChronoZonedDateTime<?> right) {
            return left.isEqual(right);
        }
    }

    static final class GreaterThanOrEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 1514185657159141882L;

        GreaterThanOrEqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new GreaterThanOrEqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2265';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result >= 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left >= right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left >= right);
        }

        @Override
        protected boolean compare(OffsetTime left, OffsetTime right) {
            return !left.isBefore(right);
        }

        @Override
        protected boolean compare(OffsetDateTime left, OffsetDateTime right) {
            return !left.isBefore(right);
        }

        @Override
        protected boolean compare(ChronoLocalDate left, ChronoLocalDate right) {
            return !left.isBefore(right);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> left, ChronoLocalDateTime<?> right) {
            return !left.isBefore(right);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> left, ChronoZonedDateTime<?> right) {
            return !left.isBefore(right);
        }
    }

    static final class GreaterThan<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 8605517892232632586L;

        GreaterThan(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new GreaterThan<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_GREATER_THAN;
        }

        @Override
        protected char symbol() {
            return '>';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result > 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left > right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left > right);
        }

        @Override
        protected boolean compare(OffsetTime left, OffsetTime right) {
            return left.isAfter(right);
        }

        @Override
        protected boolean compare(OffsetDateTime left, OffsetDateTime right) {
            return left.isAfter(right);
        }

        @Override
        protected boolean compare(ChronoLocalDate left, ChronoLocalDate right) {
            return left.isAfter(right);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> left, ChronoLocalDateTime<?> right) {
            return left.isAfter(right);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> left, ChronoZonedDateTime<?> right) {
            return left.isAfter(right);
        }
    }

    static final class LessThanOrEqualTo<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 6357459227911760871L;

        LessThanOrEqualTo(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new LessThanOrEqualTo<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO;
        }

        @Override
        protected char symbol() {
            return '\u2264';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result <= 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left <= right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left <= right);
        }

        @Override
        protected boolean compare(OffsetTime left, OffsetTime right) {
            return !left.isAfter(right);
        }

        @Override
        protected boolean compare(OffsetDateTime left, OffsetDateTime right) {
            return !left.isAfter(right);
        }

        @Override
        protected boolean compare(ChronoLocalDate left, ChronoLocalDate right) {
            return !left.isAfter(right);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> left, ChronoLocalDateTime<?> right) {
            return !left.isAfter(right);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> left, ChronoZonedDateTime<?> right) {
            return !left.isAfter(right);
        }
    }

    static final class LessThan<R>
    extends ComparisonFilter<R> {
        private static final long serialVersionUID = 6126039112844823196L;

        LessThan(Expression<R, ?> expression1, Expression<R, ?> expression2, boolean isMatchingCase, MatchAction matchAction) {
            super(expression1, expression2, isMatchingCase, matchAction);
        }

        @Override
        public Filter<R> recreate(Expression<R, ?>[] effective) {
            return new LessThan<R>(effective[0], effective[1], this.isMatchingCase, this.matchAction);
        }

        public ComparisonOperatorName getOperatorType() {
            return ComparisonOperatorName.PROPERTY_IS_LESS_THAN;
        }

        @Override
        protected char symbol() {
            return '<';
        }

        @Override
        protected boolean fromCompareTo(int result) {
            return result < 0;
        }

        @Override
        protected Number applyAsDouble(double left, double right) {
            return ComparisonFilter.number(left < right);
        }

        @Override
        protected Number applyAsLong(long left, long right) {
            return ComparisonFilter.number(left < right);
        }

        @Override
        protected boolean compare(OffsetTime left, OffsetTime right) {
            return left.isBefore(right);
        }

        @Override
        protected boolean compare(OffsetDateTime left, OffsetDateTime right) {
            return left.isBefore(right);
        }

        @Override
        protected boolean compare(ChronoLocalDate left, ChronoLocalDate right) {
            return left.isBefore(right);
        }

        @Override
        protected boolean compare(ChronoLocalDateTime<?> left, ChronoLocalDateTime<?> right) {
            return left.isBefore(right);
        }

        @Override
        protected boolean compare(ChronoZonedDateTime<?> left, ChronoZonedDateTime<?> right) {
            return left.isBefore(right);
        }
    }
}

