/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collector;
import org.apache.sis.image.AnnotatedImage;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Vocabulary;

final class StatisticsCalculator
extends AnnotatedImage {
    private final DoubleUnaryOperator[] sampleFilters;

    StatisticsCalculator(RenderedImage image, Shape areaOfInterest, DoubleUnaryOperator[] sampleFilters, boolean parallel, boolean failOnException) {
        super(image, areaOfInterest, parallel, failOnException);
        if (sampleFilters != null && ArraysExt.allEquals(sampleFilters = Arrays.copyOf(sampleFilters, ImageUtilities.getNumBands(image)), null)) {
            sampleFilters = null;
        }
        this.sampleFilters = sampleFilters;
    }

    @Override
    final Object[] getExtraParameter() {
        return this.sampleFilters;
    }

    @Override
    protected String getComputedPropertyName() {
        return "org.apache.sis.Statistics";
    }

    private static Statistics[] createAccumulator(int numBands) {
        Statistics[] stats = new Statistics[numBands];
        for (int i = 0; i < numBands; ++i) {
            stats[i] = new Statistics((CharSequence)Vocabulary.formatInternational((short)15, (Object)i));
        }
        return stats;
    }

    private DoubleConsumer[] filtered(Statistics[] accumulator) {
        if (this.sampleFilters == null) {
            return accumulator;
        }
        DoubleConsumer[] filtered = new DoubleConsumer[accumulator.length];
        for (int i = 0; i < filtered.length; ++i) {
            Statistics c = accumulator[i];
            DoubleUnaryOperator f = this.sampleFilters[i];
            filtered[i] = f == null ? c : v -> c.accept(f.applyAsDouble(v));
        }
        return filtered;
    }

    private void compute(DoubleConsumer[] accumulator, PixelIterator it) {
        double[] samples = null;
        while (it.next()) {
            if (this.areaOfInterest != null && !this.areaOfInterest.contains(it.x, it.y)) continue;
            samples = it.getPixel(samples);
            for (int i = 0; i < accumulator.length; ++i) {
                accumulator[i].accept(samples[i]);
            }
        }
    }

    @Override
    protected Object computeSequentially() {
        PixelIterator it = new PixelIterator.Builder().setRegionOfInterest(this.boundsOfInterest).create(this.source);
        Statistics[] accumulator = StatisticsCalculator.createAccumulator(it.getNumBands());
        this.compute(this.filtered(accumulator), it);
        return accumulator;
    }

    @Override
    protected Object cloneProperty(String name, Object value) {
        Statistics[] result = (Statistics[])((Statistics[])value).clone();
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].clone();
        }
        return result;
    }

    protected Collector<Raster, Statistics[], Statistics[]> collector() {
        return Collector.of(this::createAccumulator, this::compute, StatisticsCalculator::combine, new Collector.Characteristics[0]);
    }

    private Statistics[] createAccumulator() {
        return StatisticsCalculator.createAccumulator(ImageUtilities.getNumBands(this.source));
    }

    private static Statistics[] combine(Statistics[] previous, Statistics[] computed) {
        for (int i = 0; i < computed.length; ++i) {
            previous[i].combine(computed[i]);
        }
        return previous;
    }

    private void compute(Statistics[] accumulator, Raster tile) {
        this.compute(this.filtered(accumulator), new PixelIterator.Builder().setRegionOfInterest(this.boundsOfInterest).create(tile));
    }

    static DoubleUnaryOperator filterNodataValues(Number[] values) {
        double v2;
        double[] retained = new double[values.length];
        int count = 0;
        for (Number v3 : values) {
            if (v3 == null) continue;
            retained[count++] = v3.doubleValue();
        }
        Arrays.sort(retained, 0, count);
        int n = count;
        count = 0;
        for (int i = 0; i < n && !Double.isNaN(v2 = retained[i]); ++i) {
            if (count != 0) {
                if (retained[count - 1] == v2) continue;
                retained[count] = v2;
            }
            ++count;
        }
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                double nodata = retained[0];
                return v -> nodata != v ? v : Double.NaN;
            }
        }
        double[] nodata = ArraysExt.resize(retained, count);
        return v -> Arrays.binarySearch(nodata, v) < 0 ? v : Double.NaN;
    }
}

